package com.digiwin.athena.executionengine.service.facade.template.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.service.facade.template.ITransSchemaCreator;
import com.digiwin.athena.executionengine.util.FileReadUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/2/26
 */
@Service
public class TransSchemaCreator implements ITransSchemaCreator {
    private Map<String, String> transTemplateMap = new HashMap<>();

    @Override
    public String createTransSchemaByTemplate(JSONObject micTransDefinition) {
        String technique = micTransDefinition.getString("technique");
        if (transTemplateMap.containsKey(technique)) {
            return transTemplateMap.get(technique);
        }
        // 根据technique生成trans定义
        String template = FileReadUtils.readFile(technique);
        if (StringUtils.isNotEmpty(template)) {
            transTemplateMap.put(technique, template);
            return template;
        }
        return null;
    }

    @Override
    public String createTransSchemaByTechnique(String technique) {
        if (transTemplateMap.containsKey(technique)) {
            return transTemplateMap.get(technique);
        }
        // 根据technique生成trans定义
        String template = FileReadUtils.readFile(technique);
        if (StringUtils.isNotEmpty(template)) {
            transTemplateMap.put(technique, template);
            return template;
        }
        return null;
    }
}
