package com.digiwin.athena.executionengine.service.facade.transform;

import com.digiwin.athena.executionengine.exception.BusinessException;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/8/15
 */
@Service
public class FlattenerImpl implements IFlattener{
    @Override
    public List<Map<String, Object>> flatten(String mapKey, Map<String, Object> cMap) {
        boolean hasList = findListInMap(cMap);
        boolean hasMap = findMapInMap(cMap);

        if (hasList || hasMap) {
            if (hasList) {

                String listKey = existListKeyInMap(cMap);

                List<Map<String, Object>> list = new ArrayList<>();

                /*if (((List<Object>) cMap.get(listKey)).size() == 0) {
                    throw new BusinessException("spreadStep data not found,key：" + listKey);
                }*/

                if (findMapInList((List<Object>) cMap.get(listKey))) {
                    for (Object obj : (List<Object>) cMap.get(listKey)) {
                        list.addAll(flatten(listKey, (Map<String, Object>) obj));
                    }
                } else {
                    list.addAll(setMapList((List<Map<String, Object>>) cMap.get(listKey)));
                }


                Map<String, Object> otherFields = spreadObjectInFields(cMap, listKey);
                return insteadOf(cMap, list, listKey, otherFields);
            } else {

                String listKey = existMapKeyInMap(cMap);
                List<Map<String, Object>> list = flatten(listKey, (Map<String, Object>) cMap.get(listKey));

                Map<String, Object> otherFields = spreadObjectInFields(cMap, listKey);
                return insteadOf(cMap, list, listKey, otherFields);
            }

        } else {

            List<Map<String, Object>> rtn = new ArrayList<>();
            rtn.add(cMap);

            return rtn;
        }
    }

    private List<Map<String, Object>> setMapList(List<Map<String, Object>> list) {
        List<Map<String, Object>> rtn = new ArrayList<>();

        for (Object obj : list) {
            Map<String, Object> field = new HashMap<>();
            field.put("", obj);
            rtn.add(field);
        }

        return rtn;
    }

    private Map<String, Object> spreadObjectInFields(Map<String, Object> mMap, String listKey) {
        Map<String, Object> otherFields = getOtherFields(mMap, listKey);
        Map<String, Object> rtn;

        if (findMapInMap(otherFields)) {
            rtn = new HashMap<>();
            for (Map.Entry<String, Object> entry : otherFields.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    rtn.putAll(setFatherKeyIntoObjectKey(entry.getKey(), (Map<String, Object>) entry.getValue()));
                } else {
                    rtn.put(entry.getKey(), entry.getValue());
                }
            }
        } else {
            rtn = otherFields;
        }

        return rtn;
    }

    /*
     * mMap 含有待替换的层次结构
     * list 已展平的明细部分
     * listKey 展平的明细部分在cMap中的JsonKey
     */
    private List<Map<String, Object>> insteadOf(Map<String, Object> mMap, List<Map<String, Object>> list, String listKey, Map<String, Object> otherFields) {

        List<Map<String, Object>> rtn = new ArrayList<>(list.size());
        for (Map<String, Object> obj : list) {
            rtn.add(concatMap(setFatherKeyIntoObjectKey(listKey, obj), otherFields));
        }

        if (list.size() == 0) {
            Map<String, Object> tmpMap = new HashMap<>();
            tmpMap.put(listKey, null);
            rtn.add(concatMap(tmpMap, otherFields));
        }

        return rtn;
    }

    private Map<String, Object> concatMap(Map<String, Object> subMap, Map<String, Object> otherFields) {
        subMap.putAll(otherFields);
        return subMap;
    }

    private Map<String, Object> getOtherFields(Map<String, Object> mMap, String cleanKey) {
        Map<String, Object> cMap = new HashMap<>(mMap.size() - 1);
        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (entry.getKey().equals(cleanKey)) {
                continue;
            }
            cMap.put(entry.getKey(), entry.getValue());
        }
        return cMap;
    }

    private boolean findMapInList(List<Object> mList) {

        for (Object obj : mList) {
            if (obj instanceof Map) {
                return true;
            } else {
                break;
            }
        }

        return false;
    }

    private boolean findListInMap(Map<String, Object> mMap) {

        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (entry.getValue() instanceof List) {
                return true;
            }
        }

        return false;
    }

    private boolean findMapInMap(Map<String, Object> mMap) {

        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (entry.getValue() instanceof Map) {
                return true;
            }
        }

        return false;
    }

    private String existListKeyInMap(Map<String, Object> mMap) {

        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (entry.getValue() instanceof List) {
                return entry.getKey();
            }
        }

        return "";
    }


    private String existMapKeyInMap(Map<String, Object> mMap) {

        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (entry.getValue() instanceof Map) {
                return entry.getKey();
            }
        }

        return "";
    }

    //fatherKey:{A:a,B:b...}  => {fatherKey.A:a, fatherKey.B:b,...}
    private Map<String, Object> setFatherKeyIntoObjectKey(String fatherKey, Map<String, Object> mMap) {
        Map<String, Object> rtn = new HashMap<>();

        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            rtn.put(setPathKey(fatherKey, entry.getKey()), entry.getValue());
        }
        return rtn;
    }

    private String setPathKey(String fatherKey, String currentKey) {
        String symbol = "#";
        if (fatherKey.isEmpty() || currentKey.isEmpty()) {
            symbol = "";
        }

        return fatherKey + symbol + currentKey;
    }
}
