package com.digiwin.athena.executionengine.service.facade.transform;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.model.ParamElement;

import java.util.List;
import java.util.Map;

/**
 * @description: 聚合者 主要负责将展平的数据聚合回原来的样子
 * @author: ZhangJun
 * @create: 2024/8/9
 */
public interface IAggregator {


    /**
     * 展平的数据聚合回原来的样子
     *
     * @param json     保留最终聚合的数据
     * @param polyData 递归中每层需要聚合的数据
     * @param level    当前递归层级
     * @param maxDepth 递归最深层次
     * @param nodeMap  节点信息
     */
    void processAggregation(JSONObject json, List<Map<String, Object>> polyData, int level, int maxDepth, Map<String, MetaNode> nodeMap);


    /**
     * 分析api入参元数据
     *
     * @param paramElements
     * @return
     */
    Map<String, MetaNode> analyzeAPIMetaData(List<ParamElement> paramElements);


}
