package com.digiwin.athena.executionengine.service.srp;

import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.model.ServiceResult;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2022/5/5
 */
public interface ITransSrp {

    /**
     * 执行trans的业务类
     *
     * @param tenantId
     * @param ruleId
     * @param reqMap
     * @param eocMap
     * @return
     */
    ServiceResult runTrans(String tenantId, String ruleId, Map<String, Object> reqMap, Map<String, Object> eocMap);
    ServiceResult runTransByTransAction(ExecuteContext context, String ruleId, Map<String, Object> reqMap);

    /**
     * 用于二次计算的trans的业务类
     * @param tenantId
     * @param recasts
     * @param data
     * @return
     */
    ServiceResult runTrans(String tenantId, List<Map<String, Object>> recasts, Object data);
}
