package com.digiwin.athena.executionengine.util;

import com.digiwin.athena.executionengine.constant.CommonConstant;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @description: 执行引擎的分析工具类
 * @author: renwm
 * @date: 2020/6/18 15:16
 */
public class AnalysisUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalysisUtils.class);

    private AnalysisUtils() {
    }

    /**
     * 点分隔符连接
     *
     * @param elements
     * @return
     */
    public static String concatByDot(String... elements) {
        return StringUtils.join(elements, CommonConstant.SEPARATOR_DOT);
    }

    public static String truncateKey(String key) {
        if (StringUtils.isBlank(key)) {
            return key;
        }
        String[] keyArray = key.split("\\.");
        return keyArray[keyArray.length - 1];
    }
}
