package com.digiwin.athena.executionengine.util;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2021/5/31
 */
@Component
public class ContextUtils implements ApplicationContextAware {

    private static ApplicationContext moduleSpringContext;

    public static <T> T getBean(Class<T> requiredType, Object... args) {
        return moduleSpringContext.getBean(requiredType, args);
    }

    public static <T> T getBean(String beanName, Object... args) {
        return (T) moduleSpringContext.getBean(beanName, args);
    }

    public static <T> T getBean(String beanName, Class<T> requiredType) {
        return (T) moduleSpringContext.getBean(beanName, requiredType);
    }


    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (moduleSpringContext == null) {
            ContextUtils.moduleSpringContext = applicationContext;
        }
    }
}
