package com.digiwin.athena.executionengine.util;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Optional;

/**
 * @description: 服务返回结果处理类
 * @author: renwm
 * @date: 2020/6/8 17:26
 */
public class ServiceResponseUtils {
    private static final int ESP_SUCCESS_CODE = 0;

    private ServiceResponseUtils() {
    }


    /**
     * 获取平台响应结果
     *
     * @param respContent
     * @return
     */
    public static String getDwServiceResponse(String respContent) {
        if (StringUtils.isBlank(respContent)) {
            return null;
        }

        JSONObject jsonObject = JSONObject.parseObject(respContent);
        if (ModuleProperty.RESPONSE_SUCCESS_STATUS != jsonObject.getIntValue(FieldNameConstant.DW_SERVICE_STATUS)) {
            return null;
        }
        return jsonObject.getString(FieldNameConstant.DW_SERVICE_RESPONSE);
    }


    public static JSONObject getThemeMapResp(String respContent) {
        String data = getDwServiceResponse(respContent);

        if (null == data) {
            return null;
        }

        return JSONObject.parseObject(data);

    }

    /**
     * 获取ThemeMap返回结果
     *
     * @param respObj
     * @return
     */
    public static JSONObject getThemeMapData(JSONObject respObj) {

        if (null == respObj) {
            return null;
        }
        JSONObject dataObj = respObj.getJSONObject(FieldNameConstant.THEMEMAP_SERVICE_DATA);
        return checkObjEmpty(dataObj);
    }

    public static boolean getThemeMapStatus(JSONObject respObj) {
        if (null == respObj) {
            return false;
        }
        return respObj.getBooleanValue(FieldNameConstant.THEMEMAP_SERVICE_SUCCESS);
    }

    /**
     * 获取esp返回对象
     *
     * @param respContent
     * @return
     */
    public static JSONObject getEspRespData(String respContent) {

        JSONObject respObj = Optional.ofNullable(respContent)
                .map((resp) -> JSONObject.parseObject(resp))
                .map((obj) -> obj.getJSONObject(FieldNameConstant.ESP_STD_DATA))
                .orElse(null);

        return checkObjEmpty(respObj);
    }

    /**
     * 获取ESP返回状态
     *
     * @param respObj
     * @return
     */
    public static boolean getEspRespStatus(JSONObject respObj) {

        return Optional.ofNullable(respObj)
                .map(obj -> obj.getJSONObject(FieldNameConstant.ESP_EXECUTION))
                .map(obj -> ESP_SUCCESS_CODE == obj.getIntValue(FieldNameConstant.ESP_CODE))
                .orElse(false);
    }

    /**
     * 获取esp返回参数
     *
     * @param respObj
     * @return
     */
    public static JSONObject getEspRespParameter(JSONObject respObj) {

        if (null == respObj) {
            return null;
        }
        JSONObject paramObj = respObj.getJSONObject(FieldNameConstant.ESP_PARAMETER);

        return checkObjEmpty(paramObj);
    }

    /**
     * 获取BPM 返回结果
     *
     * @param respContent
     * @return
     */
    public static JSONObject getBpmResp(String respContent) {
        return checkObjEmpty(getDapResp(respContent));
    }


    /**
     * 获取任务引擎 返回结果
     *
     * @param respContent
     * @return
     */
    public static JSONObject getDataEventResp(String respContent) {
        return checkObjEmpty(getDapResp(respContent));
    }

    /**
     * 获取服务编排 返回结果
     *
     * @param respContent
     * @return
     */
    public static JSONObject getServiceComposerResp(String respContent) {
        return checkObjEmpty(getDapResp(respContent));
    }


    /**
     * 获取dap平台规范的response 返回结果
     *
     * @param respContent
     * @return
     */
    public static JSONObject getDapResp(String respContent) {
        if (null == respContent) {
            return null;
        }
        String resp = getDwServiceResponse(respContent);
        if (null == resp) {
            return null;
        }
        JSONObject paramObj = JSONObject.parseObject(resp);
        return paramObj;
    }

    private static JSONObject checkObjEmpty(JSONObject paramObj) {
        if (MapUtils.isEmpty(paramObj)) {
            return null;
        }
        return paramObj;
    }
}
