/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.aop.ActionMock;
import com.digiwin.athena.executionengine.core.aop.Debug;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.dto.ErrorLog;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.BusinessException;
import com.digiwin.athena.executionengine.model.BasePage;
import com.digiwin.athena.executionengine.model.DataDescription;
import com.digiwin.athena.executionengine.service.facade.schema.ISchemaBuilder;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.DateUtils;
import com.digiwin.athena.executionengine.util.JsonUtil;
import com.digiwin.athena.executionengine.util.LogUtils;
import com.digiwin.athena.smartdata.sdk.DatasourceProxyInitialize;
import com.digiwin.athena.smartdata.sdk.exception.CustomException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="BMDGeneralAction")
public class BMDGeneralAction
extends ActionBase {
    private static final int MAX_CYCLES = 20;
    private static final Logger LOGGER = LoggerFactory.getLogger(BMDGeneralAction.class);

    @Override
    @ActionMock
    @Debug
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        Map<String, Object> querySchema = null;
        try {
            Integer pageSize;
            Integer total;
            Map detail;
            Map bmd;
            String productLine = actionParam.getMetaObj().containsKey((Object)"productLine") ? actionParam.getMetaObj().getString("productLine") : "ERP";
            DataDescription dataDescription = context.getInputParam().getDataDescription();
            if (!dataDescription.isDataset() && dataDescription.getProductLineRows() != null && !dataDescription.getProductLineRows().isEmpty()) {
                for (int i = 0; i < dataDescription.getProductLineRows().size(); ++i) {
                    JSONObject rowJson = dataDescription.getProductLineRows().getJSONObject(i);
                    if (!productLine.equals(rowJson.getString("productLine"))) continue;
                    dataDescription.setPermissions(rowJson.getJSONObject("row"));
                    break;
                }
            } else if (dataDescription.isDataset()) {
                JSONArray datasetPermissions = JSONArray.parseArray((String)JSONObject.toJSONString((Object)dataDescription.getProductLineRows()));
                dataDescription.setDatasetPermissions(datasetPermissions);
            }
            if (!CollectionUtils.isEmpty(context.getInputParam().getParam())) {
                reqMap.putAll(context.getInputParam().getParam());
            }
            querySchema = !CollectionUtils.isEmpty((Map)context.getInputParam().getDataDescription().getDynamicSchema()) ? ContextUtils.getBean(ISchemaBuilder.class, new Object[0]).buildQuerySchemaByNewStrategy(actionParam.getQuerySchema(), reqMap, context.getInputParam().getDataDescription()) : ContextUtils.getBean(ISchemaBuilder.class, new Object[0]).buildQuerySchema(actionParam.getQuerySchema(), reqMap, actionParam.getActionId(), context.getInputParam().getDataDescription());
            BasePage basePage = this.createBasePage(querySchema);
            querySchema.put("page", basePage);
            querySchema.put("productLine", productLine);
            ArrayList list = new ArrayList();
            String datasource = (String)context.getInputParam().getSysParam().get("dataSource");
            String userId = (String)context.getInputParam().getSysParam().get("userId");
            long startTime = System.currentTimeMillis();
            List querySql = null;
            int cycles = 1;
            while ((bmd = DatasourceProxyInitialize.getData((String)datasource, querySchema, (String)context.getTenantId(), (String)context.getLocale(), (String)context.getToken(), (String)userId, (String)context.getRouterKey(), context.getInputParam().getEocMaps(), context.getInputParam().getRoles(), (String)String.valueOf(context.getMessageId()))) != null && !bmd.isEmpty() && (detail = (Map)bmd.get("data")) != null && !detail.isEmpty() && detail.containsKey("total") && detail.containsKey("data") && (total = Integer.valueOf("dcp".equals(datasource) ? Integer.parseInt((String)detail.get("total")) : (Integer)detail.get("total"))) != 0) {
                querySql = (List)detail.get("querySql");
                if (total >= 150000) {
                    context.setExecuteStatus(false);
                    context.setErrorLog(this.buildErrorLog(actionParam));
                    throw new BusinessException(ErrorCodeEnum.ACTION_PULLING_DATA_OVERFLOW);
                }
                list.addAll((List)detail.get("data"));
                if (list.size() >= total) break;
                basePage.setPageNo(basePage.getPageNo() + 1);
                querySchema.put("page", basePage);
                ++cycles;
            }
            if (context.isDebug() && !CollectionUtils.isEmpty(querySql)) {
                context.getQuerySqlMap().put(actionParam.getActionId(), querySql);
            }
            if ((pageSize = Optional.ofNullable(querySchema).map(map -> map.get("page")).map(page -> JsonUtil.getObject(JsonUtil.getJsonString(page), BasePage.class)).orElse(BasePage.createDefaultPage()).getPageSize()) < 10000 && cycles > 20) {
                LogUtils.buildAgileLog("executeBmdAction", "P.EE.500.0017", "actionId:" + actionParam.getActionId() + ",action\u5165\u53c2:" + JSONObject.toJSONString(reqMap) + "\uff0c\u67e5\u8be2\u65b9\u6848:" + JSONObject.toJSONString(querySchema), "BMD\u8c03\u7528\u8fb9\u7f18\u6b21\u6570\u8d85\u8fc720\u6b21", "\u5efa\u8bae\u5c06pageSize\u8bbe\u7f6e\u4e3a\u5927\u4e8e\u7b49\u4e8e10000\u7684\u503c");
            }
            long timeTaken = System.currentTimeMillis() - startTime;
            LOGGER.info(String.format("actionId\uff1a%s\uff0c\u67e5\u8be2\u8017\u65f6:%sms\uff0c\u67e5\u8be2\u7b14\u6570:%s,\u67e5\u8be2\u65b9\u6848:%s", actionParam.getActionId(), timeTaken, list.size(), JSONObject.toJSONString(querySchema)));
            LogUtils.buildAgileLog("executeBmdAction", LogUtils.SUCCESS, "actionId:" + actionParam.getActionId() + ",action\u5165\u53c2:" + JSONObject.toJSONString(reqMap) + "\uff0c\u67e5\u8be2\u65b9\u6848:" + JSONObject.toJSONString(querySchema), "\u6570\u636e\u7b14\u6570\uff1a" + list.size(), "");
            context.setExecuteStatus(true);
            return list;
        }
        catch (Exception e) {
            if (context.getErrorLog() == null && e instanceof CustomException) {
                ErrorLog errorLog = BMDGeneralAction.getErrorLog(actionParam, (CustomException)e);
                context.setErrorLog(errorLog);
            }
            String message = e.getMessage();
            if (e instanceof NullPointerException) {
                message = "NullPointerException";
            } else if (e instanceof CustomException) {
                message = ((CustomException)e).getErrorMessage();
            }
            LogUtils.buildAgileLog("executeBmdAction", "U.EE.500.0013", "actionId:" + actionParam.getActionId() + ",action\u5165\u53c2:" + JSONObject.toJSONString(reqMap) + "\uff0c\u67e5\u8be2\u65b9\u6848:" + JSONObject.toJSONString(querySchema), "\u4ee3\u7801\u62a5\u9519\uff0c\u5931\u8d25\u539f\u56e0:\u3010" + message + "\u3011", "\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
            context.setExecuteStatus(false);
            LOGGER.error("\u8c03\u7528BMD\u83b7\u53d6\u6570\u636e\u5f02\u5e38,\u67e5\u8be2\u65b9\u6848:{}", (Object)JSONObject.toJSONString(querySchema), (Object)e);
            throw e;
        }
    }

    private ErrorLog buildErrorLog(ActionParam actionParam) {
        ErrorLog errorLog = new ErrorLog();
        errorLog.setErrorCode(ErrorCodeEnum.ACTION_PULLING_DATA_OVERFLOW.getCode());
        errorLog.setErrorLocation("\u6570\u636e\u62c9\u53d6\u7ec4\u4ef6\uff0cactionId:" + actionParam.getActionId());
        errorLog.setErrorDescription("\u5355\u4e2a\u67e5\u8be2\u65b9\u6848\u6570\u636e\u91cf\u8d85\u51fa\u9650\u5236");
        errorLog.setErrorTimestamp(DateUtils.getCurrentDateTime());
        errorLog.setErrorMessage(ErrorCodeEnum.ACTION_PULLING_DATA_OVERFLOW.getMessage());
        errorLog.setPossibleCausesAndGuidance("\u6570\u636e\u91cf\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u5c1d\u8bd5\u6dfb\u52a0\u66f4\u591a\u7684\u7b5b\u9009\u6761\u4ef6\u8fdb\u884c\u67e5\u8be2,\u8282\u70b9id:" + actionParam.getActionId());
        return errorLog;
    }

    private static ErrorLog getErrorLog(ActionParam actionParam, CustomException customException) {
        ErrorLog errorLog = new ErrorLog();
        errorLog.setErrorCode(customException.getErrorCode());
        errorLog.setErrorLocation("\u6570\u636e\u62c9\u53d6\u7ec4\u4ef6\uff0cactionId:" + actionParam.getActionId());
        errorLog.setErrorDescription(customException.getErrorMessage());
        errorLog.setErrorTimestamp(DateUtils.getCurrentDateTime());
        errorLog.setErrorMessage(customException.getErrorMessage());
        errorLog.setPossibleCausesAndGuidance("\u8bf7\u68c0\u67e5\u6570\u636e\u62c9\u53d6\u8282\u70b9\u914d\u7f6e\u662f\u5426\u6b63\u5e38,\u8282\u70b9id:" + actionParam.getActionId());
        return errorLog;
    }

    private Map<String, Object> generatePocSchema(JSONObject querySchema, Object obj) {
        JSONObject dynamicSchema = (JSONObject)obj;
        if (!CollectionUtils.isEmpty((Collection)dynamicSchema.getJSONArray("dimensions"))) {
            JSONArray dynamicDimensions = dynamicSchema.getJSONArray("dimensions");
            Map<String, String> map = dynamicDimensions.stream().collect(Collectors.toMap(item -> ((JSONObject)item).getString("field"), item -> ((JSONObject)item).getString("field")));
            querySchema.getJSONArray("dimensions").stream().filter(o -> !map.containsKey(((JSONObject)o).getString("field"))).forEach(o -> ((JSONObject)o).put("defaultValue", (Object)"auto"));
        }
        if (!CollectionUtils.isEmpty((Collection)dynamicSchema.getJSONArray("measures"))) {
            querySchema.fluentRemove((Object)"measures").put("measures", (Object)dynamicSchema.getJSONArray("measures"));
        }
        if (!CollectionUtils.isEmpty((Collection)dynamicSchema.getJSONArray("filter"))) {
            JSONObject filter = new JSONObject();
            JSONArray children = new JSONArray();
            filter.put("logical", (Object)"and");
            filter.put("children", (Object)children);
            children.addAll((Collection)dynamicSchema.getJSONArray("filter"));
            children.add((Object)querySchema.getJSONObject("filter"));
            querySchema.put("filter", (Object)filter);
        }
        return querySchema;
    }

    private BasePage createBasePage(Map<String, Object> querySchema) {
        BasePage pageObj = Optional.ofNullable(querySchema).map(map -> map.get("page")).map(page -> JsonUtil.getObject(JsonUtil.getJsonString(page), BasePage.class)).orElse(BasePage.createDefaultPage());
        return pageObj;
    }

    private void createDefaultData(List<Object> list, Map<String, Object> detail) {
        if (!detail.containsKey("meta")) {
            return;
        }
        List meta = (List)detail.get("meta");
        HashMap<String, Object> defaultData = new HashMap<String, Object>();
        for (Object metaObj : meta) {
            Map entry = (Map)metaObj;
            switch ((Integer)entry.get("columnDataType")) {
                case 0: {
                    defaultData.put((String)entry.get("columnName"), "");
                    break;
                }
                case 1: 
                case 7: {
                    defaultData.put((String)entry.get("columnName"), new Date());
                    break;
                }
                case 2: {
                    defaultData.put((String)entry.get("columnName"), 0);
                    break;
                }
                case 3: {
                    defaultData.put((String)entry.get("columnName"), Float.valueOf(0.0f));
                    break;
                }
                case 4: {
                    defaultData.put((String)entry.get("columnName"), false);
                    break;
                }
            }
        }
        list.add(defaultData);
    }
}

