/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.core.container.ExecuteErrorMessage;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ThirdPartyAction")
public class ThirdPartyAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartyAction.class);
    private static final String URL = "url";
    private static final String METHOD = "method";

    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        String url = actionParam.getMetaObj().getString(URL);
        String method = actionParam.getMetaObj().getString(METHOD);
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>(1);
            headerMap.put("Content-Type", "application/json;charset=UTF-8");
            String httpRespContent = HttpClientUtils.doRequest(method, url, headerMap, reqMap);
            if (httpRespContent == null) {
                context.setExecuteStatus(false);
                LOGGER.error("\u8c03\u7528\u7b2c\u4e09\u65b9API{}:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1anull", (Object)actionParam.getActionId(), (Object)JSON.toJSONString(reqMap));
                return null;
            }
            LOGGER.info("\u8c03\u7528\u7b2c\u4e09\u65b9API{}:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", new Object[]{actionParam.getActionId(), JSON.toJSONString(reqMap), httpRespContent});
            JSONObject respObj = JSONObject.parseObject((String)httpRespContent);
            if (respObj == null) {
                context.setExecuteStatus(false);
            } else {
                context.setExecuteStatus(true);
            }
            return respObj;
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u7b2c\u4e09\u65b9API\u9519\u8bef", (Throwable)e);
            context.setExecuteStatus(false);
            ExecuteErrorMessage executeErrorMessage = new ExecuteErrorMessage();
            executeErrorMessage.setErrorMsg(e.getMessage());
            executeErrorMessage.setErrorCode("P.EE.600.0006");
            executeErrorMessage.setActionTypeEnum(ActionTypeEnum.THIRD_PARTY);
            context.setExecuteErrorMessage(executeErrorMessage);
            throw e;
        }
    }
}

