/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.param;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.param.ParamBase;
import com.digiwin.athena.executionengine.enumtype.ParamTypeEnum;
import com.digiwin.athena.executionengine.util.ClassUtils;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParamFactory.class);

    public static ParamBase createParam(JSONObject paramObj) {
        try {
            String type = paramObj.getString("type");
            ParamTypeEnum typeEnum = ParamTypeEnum.getEnumByType(type);
            ParamBase paramInstance = ClassUtils.getParamInstance(typeEnum.getClassName());
            Optional.ofNullable(paramInstance).ifPresent(instance -> instance.initInstance(paramObj));
            return paramInstance;
        }
        catch (Exception e) {
            LOGGER.error("{}\u521b\u5efaParamBase\u5b9e\u4f8b\u5bf9\u8c61\u5f02\u5e38:{}", (Object)paramObj, (Object)e);
            return null;
        }
    }
}

