/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.enumtype.ValueTypeEnum;
import com.digiwin.athena.executionengine.model.ParamElement;
import com.digiwin.athena.executionengine.model.input.InputParamModule;
import com.digiwin.athena.executionengine.service.facade.analyzer.AbstractAnalyzerBase;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingHandler;
import com.digiwin.athena.executionengine.util.AnalysisUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="engineInputParamAnalyzer")
public class InputParamAnalyzer
extends AbstractAnalyzerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputParamAnalyzer.class);

    @Override
    protected void analysisHandler(JSONObject executionRule) {
        InputParamModule inputParam = InputParamAnalyzer.getLocalContext().getInputParam();
        if (MapUtils.isEmpty(inputParam.getInputParam())) {
            LOGGER.warn("\u6267\u884c\u5f15\u64ce\u6267\u884c\u6ca1\u6709\u9700\u8981\u5206\u6790\u7684\u6267\u884c\u5165\u53c2");
            return;
        }
        this.analysisInputParam("", "$", inputParam.getInputParam(), "ExecutionParam");
        inputParam.getInputParam().clear();
        this.analysisInputParam("sysParam", "$", inputParam.getSysParam(), "ExecutionSysParam");
    }

    private void analysisInputParam(String path, String jsonPath, Map<String, Object> inputMap, String inputParamPart) {
        if (MapUtils.isEmpty(inputMap)) {
            return;
        }
        if (FieldNameConstant.isValidInputParamPath(path)) {
            path = "$";
        }
        for (Map.Entry<String, Object> entry : inputMap.entrySet()) {
            ParamElement paramElement = new ParamElement();
            paramElement.setInputParamPart(inputParamPart);
            paramElement.setParamName(entry.getKey());
            paramElement.setValueType(ValueTypeEnum.STRING);
            paramElement.setParamPath(entry.getKey());
            paramElement.setArray(false);
            if (StringUtils.isNotBlank((CharSequence)path)) {
                paramElement.setParamPath(AnalysisUtils.concatByDot(path, entry.getKey()));
            }
            paramElement.setElementJsonPath(AnalysisUtils.concatByDot(jsonPath, entry.getKey()));
            InputParamAnalyzer.getLocalContext().addParamElement(paramElement.getParamPath(), paramElement);
            if (entry.getValue() instanceof List) {
                List valList = (List)entry.getValue();
                if (CollectionUtils.isNotEmpty((Collection)valList) && valList.get(0) instanceof Map) {
                    for (Object object : valList) {
                        paramElement.setElementJsonPath(AnalysisUtils.concatByDot(jsonPath, entry.getKey()));
                        this.analysisInputParam(paramElement.getParamPath(), paramElement.getElementJsonPath() + "[*]", (Map)object, inputParamPart);
                    }
                } else if (InputParamAnalyzer.getLocalContext().isNotExistParamElement(paramElement.getParamPath())) {
                    InputParamAnalyzer.getLocalContext().addInputParamKey(paramElement.getParamPath());
                }
                paramElement.setValueType(ValueTypeEnum.ARRAY);
                paramElement.setArray(true);
                continue;
            }
            if (entry.getValue() instanceof Map) {
                paramElement.setValueType(ValueTypeEnum.OBJECT);
                this.analysisInputParam(paramElement.getParamPath(), paramElement.getElementJsonPath(), (Map)entry.getValue(), inputParamPart);
                continue;
            }
            if (!InputParamAnalyzer.getLocalContext().isNotExistParamElement(paramElement.getParamPath())) continue;
            InputParamAnalyzer.getLocalContext().addInputParamKey(paramElement.getParamPath(), inputParamPart);
        }
    }

    private void inputKeyAnalyze() {
        HashSet<String> shortageKeySet = new HashSet<String>();
        DataMappingHandler dataMappingHandler = InputParamAnalyzer.getLocalContext().getDataMappingManager().getDatMappingHandler(InputParamAnalyzer.getLocalContext().getInputParam().getActionId(), "ExecutionParam");
        Set<String> allLeafParamPathSet = dataMappingHandler.getLeafParamPath();
        for (String paramPath : allLeafParamPathSet) {
            if (shortageKeySet.contains(paramPath)) continue;
            this.calculateShortageKeys(paramPath, shortageKeySet, dataMappingHandler);
        }
        allLeafParamPathSet.removeAll(shortageKeySet);
    }

    private void calculateShortageKeys(String paramPath, Set<String> shortageKeySet, DataMappingHandler dataMappingHandler) {
        String lastCollectionParamPath = dataMappingHandler.getLastCollectionNodeParamPath(paramPath);
        if (lastCollectionParamPath == null) {
            return;
        }
        Map<String, ? extends Number> groupingZone = this.getGroupingZone(paramPath, dataMappingHandler);
        boolean isTop = dataMappingHandler.isRootNode(lastCollectionParamPath);
        boolean matchResult = isTop ? dataMappingHandler.getTotalCountByParamPath(lastCollectionParamPath) == groupingZone.keySet().size() : this.matchWithParentCollectionZone(groupingZone, dataMappingHandler.getZoneByParamPath(lastCollectionParamPath));
        if (!matchResult) {
            this.addChildLeafNodeToShortage(paramPath, shortageKeySet, dataMappingHandler);
            return;
        }
        if (!isTop) {
            this.calculateShortageKeys(lastCollectionParamPath, shortageKeySet, dataMappingHandler);
        }
    }

    private void addChildLeafNodeToShortage(String paramPath, Set<String> shortageKeySet, DataMappingHandler dataMappingHandler) {
        if (dataMappingHandler.isLeafNode(paramPath)) {
            shortageKeySet.add(paramPath);
            return;
        }
        List<String> childrenParamPathList = dataMappingHandler.getChildrenParamPath(paramPath);
        for (String path : childrenParamPathList) {
            this.addChildLeafNodeToShortage(path, shortageKeySet, dataMappingHandler);
        }
    }

    private boolean matchWithParentCollectionZone(Map<String, ? extends Number> groupingZone, Map<String, Integer> parentNodeZone) {
        for (Map.Entry<String, Integer> entry : parentNodeZone.entrySet()) {
            int groupZoneValue;
            String key = entry.getKey();
            if (!groupingZone.containsKey(key)) {
                return false;
            }
            int parentNodeZoneValue = entry.getValue();
            if (parentNodeZoneValue == (groupZoneValue = groupingZone.get(key).intValue())) continue;
            return false;
        }
        return true;
    }

    private Map<String, ? extends Number> getGroupingZone(String paramPath, DataMappingHandler dataMappingHandler) {
        String parentNodeParamPath = dataMappingHandler.getParentParamPath(paramPath);
        if (dataMappingHandler.isRootNode(parentNodeParamPath)) {
            return dataMappingHandler.getZoneByParamPath(paramPath);
        }
        Map<String, Integer> zone = this.getProcessedZone(paramPath, dataMappingHandler);
        ArrayList<String> subKeyList = new ArrayList<String>();
        for (String key : zone.keySet()) {
            subKeyList.add(key.substring(0, key.lastIndexOf(".")));
        }
        Map<String, Long> collect = subKeyList.stream().collect(Collectors.groupingBy(item -> item, Collectors.counting()));
        return MapUtils.isEmpty(collect) ? Maps.newHashMap() : collect;
    }

    private Map<String, Integer> getProcessedZone(String paramPath, DataMappingHandler dataMappingHandler) {
        String parentNodeParamPath = dataMappingHandler.getParentParamPath(paramPath);
        Map<String, Integer> zone = dataMappingHandler.getZoneByParamPath(paramPath);
        if (dataMappingHandler.isArray(parentNodeParamPath)) {
            return zone;
        }
        HashMap<String, Integer> newZone = new HashMap<String, Integer>();
        String lastCollectionParamPath = dataMappingHandler.getLastCollectionNodeParamPath(paramPath);
        int idx = StringUtils.countMatches((CharSequence)lastCollectionParamPath, (CharSequence)".");
        for (Map.Entry<String, Integer> entry : zone.entrySet()) {
            String key = entry.getKey();
            int pos = StringUtils.ordinalIndexOf((CharSequence)key, (CharSequence)".", (int)(idx + 1));
            newZone.put(key.substring(0, pos), entry.getValue());
        }
        return newZone;
    }
}

