/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.transform;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.model.ParamElement;
import com.digiwin.athena.executionengine.service.facade.transform.IAggregator;
import com.digiwin.athena.executionengine.service.facade.transform.MetaNode;
import com.digiwin.athena.executionengine.service.facade.transform.Polymerization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AggregatorImpl
implements IAggregator {
    @Override
    public void processAggregation(JSONObject json, List<Map<String, Object>> polyData, int level, int maxDepth, Map<String, MetaNode> nodeMap) {
        Polymerization polymerization = this.genPolymerizationInfo(level, nodeMap);
        if (level >= maxDepth || StringUtils.isEmpty((CharSequence)polymerization.getNewField())) {
            json.put("temp_" + level, polyData);
            return;
        }
        List<Map<String, Object>> result = this.aggregatedData(polymerization, polyData, nodeMap);
        json.put("temp_" + level, result);
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        for (Map<String, Object> stringObjectMap : result) {
            Object data = stringObjectMap.get(polymerization.getNewField());
            List nextPolyData = null;
            if (data instanceof List) {
                nextPolyData = (List)stringObjectMap.get(polymerization.getNewField());
                this.processAggregation(json, nextPolyData, level + 1, maxDepth, nodeMap);
                stringObjectMap.put(polymerization.getNewField(), json.get((Object)("temp_" + (level + 1))));
                continue;
            }
            if (!(data instanceof Map)) continue;
            this.processAggregationMap(json, (Map)data, level + 1, maxDepth, nodeMap);
        }
        if (level == 1) {
            json.put("result", result);
        }
    }

    private void processAggregationMap(JSONObject json, Map<String, Object> map, int level, int maxDepth, Map<String, MetaNode> nodeMap) {
        Polymerization polymerization = this.genPolymerizationInfo(level, nodeMap);
        if (level >= maxDepth || StringUtils.isEmpty((CharSequence)polymerization.getNewField())) {
            return;
        }
        if (nodeMap.get(polymerization.getNewField()) != null && nodeMap.get(polymerization.getNewField()).isArray()) {
            this.aggregatedMapData(polymerization, map, nodeMap);
            List polyData = (List)map.get(polymerization.getNewField());
            if (CollectionUtils.isEmpty((Collection)polyData)) {
                return;
            }
            for (Map stringObjectMap : polyData) {
                this.processAggregationMap(json, stringObjectMap, level + 1, maxDepth, nodeMap);
            }
        } else {
            this.processAggregationMap(json, map, level + 1, maxDepth, nodeMap);
        }
    }

    private void aggregatedMapData(Polymerization polymerization, Map<String, Object> map, Map<String, MetaNode> nodeMap) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        HashMap<String, Object> elementMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> rowElementList = new ArrayList<HashMap<String, Object>>();
        List<String> polymerizationFields = polymerization.getPolymerizationFields();
        for (Map.Entry<String, Object> entryData : map.entrySet()) {
            String key;
            if (polymerizationFields.contains(entryData.getKey())) {
                key = this.truncateKey(entryData.getKey());
                rowMap.put(key, entryData.getValue());
            } else {
                key = this.truncateKey(entryData.getKey());
                elementMap.put(key, entryData.getValue());
                rowElementList.add(elementMap);
            }
            rowMap.put(polymerization.getNewField(), rowElementList);
        }
        map.clear();
        map.putAll(rowMap);
    }

    @Override
    public Map<String, MetaNode> analyzeAPIMetaData(List<ParamElement> paramElements) {
        HashMap<String, MetaNode> nodeMap = new HashMap<String, MetaNode>();
        this.analyzeParameters(nodeMap, 1, "", paramElements);
        return nodeMap;
    }

    private void analyzeParameters(Map<String, MetaNode> nodeMap, int depth, String parentPath, List<ParamElement> paramElements) {
        for (ParamElement paramElement : paramElements) {
            String currentPath = parentPath.isEmpty() ? paramElement.getParamName() : parentPath + "." + paramElement.getParamName();
            boolean isLeaf = CollectionUtils.isEmpty(paramElement.getChildElements());
            nodeMap.put(paramElement.getParamName(), new MetaNode(paramElement.getParamName(), depth, currentPath, paramElement.getValueType().getType(), isLeaf, paramElement.getArray()));
            if (isLeaf) continue;
            this.analyzeParameters(nodeMap, depth + 1, currentPath, paramElement.getChildElements());
        }
    }

    private Polymerization genPolymerizationInfo(int level, Map<String, MetaNode> nodeMap) {
        List collect = nodeMap.values().stream().filter(n -> n.getDepth() == level).collect(Collectors.toList());
        ArrayList<String> fields = new ArrayList<String>();
        String newField = null;
        for (MetaNode node : collect) {
            if (node.isLeaf()) {
                fields.add(node.getName());
                continue;
            }
            newField = node.getName();
        }
        return new Polymerization(fields, newField);
    }

    private List<Map<String, Object>> aggregatedData(Polymerization polymerization, List<Map<String, Object>> dataList, Map<String, MetaNode> nodeMap) {
        List<String> polymerizationFields = polymerization.getPolymerizationFields();
        ArrayList<Map<String, Object>> rootList = new ArrayList<Map<String, Object>>();
        if (nodeMap.get(polymerization.getNewField()) != null && !nodeMap.get(polymerization.getNewField()).isArray()) {
            for (Map<String, Object> data : dataList) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                HashMap<String, Object> elementMap = new HashMap<String, Object>();
                for (Map.Entry<String, Object> entryData : data.entrySet()) {
                    String key;
                    if (polymerizationFields.contains(entryData.getKey())) {
                        key = this.truncateKey(entryData.getKey());
                        rowMap.put(key, entryData.getValue());
                        continue;
                    }
                    key = this.truncateKey(entryData.getKey());
                    elementMap.put(key, entryData.getValue());
                }
                if (!MapUtils.isNotEmpty(elementMap)) continue;
                rowMap.put(polymerization.getNewField(), elementMap);
                rootList.add(rowMap);
            }
            return rootList;
        }
        Map<String, List<Map>> groupMap = dataList.stream().collect(Collectors.groupingBy(map -> {
            StringBuilder builder = new StringBuilder();
            polymerizationFields.forEach(item -> builder.append(map.get(item)));
            return builder.toString();
        }));
        for (Map.Entry<String, List<Map>> entry : groupMap.entrySet()) {
            HashMap rowMap = new HashMap();
            ArrayList rowElementList = new ArrayList();
            for (Map data : entry.getValue()) {
                HashMap elementMap = new HashMap();
                for (Map.Entry entryData : data.entrySet()) {
                    String key;
                    if (polymerizationFields.contains(entryData.getKey())) {
                        key = this.truncateKey((String)entryData.getKey());
                        rowMap.put(key, entryData.getValue());
                        continue;
                    }
                    key = this.truncateKey((String)entryData.getKey());
                    elementMap.put(key, entryData.getValue());
                }
                if (!MapUtils.isNotEmpty(elementMap)) continue;
                rowElementList.add(elementMap);
            }
            if (CollectionUtils.isNotEmpty(rowElementList)) {
                rowMap.put(polymerization.getNewField(), rowElementList);
            }
            rootList.add(rowMap);
        }
        return rootList;
    }

    private String truncateKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return key;
        }
        String[] keyArray = key.split("\\#");
        return keyArray[keyArray.length - 1];
    }
}

