/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.digiwin.athena.executionengine.exception.BusinessException;
import com.digiwin.athena.executionengine.model.trans.DealResult;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="spread")
public class SpreadStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpreadStep.class);

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        try {
            Object inputData = this.getCurrentData(step.getPrevStepNameList());
            if (inputData instanceof Map && MapUtils.isEmpty((Map)((Map)inputData))) {
                dealResult.setSuccess(Lists.newArrayList());
                return dealResult;
            }
            if (inputData instanceof List && CollectionUtils.isEmpty((Collection)((List)inputData))) {
                dealResult.setSuccess(Lists.newArrayList());
                return dealResult;
            }
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("", inputData);
            dealResult.setSuccess(this.enterStruct("", input));
            return dealResult;
        }
        catch (Exception e) {
            LOGGER.error("\u5c55\u5e73\u7ec4\u4ef6\u6267\u884c\u5f02\u5e38");
            throw e;
        }
    }

    @Override
    public boolean defineCheck(StepElement stepElement) {
        return true;
    }

    public List<Map<String, Object>> enterStruct(String mapKey, Map<String, Object> cMap) {
        boolean hasList = this.findListInMap(cMap);
        boolean hasMap = this.findMapInMap(cMap);
        if (hasList || hasMap) {
            if (hasList) {
                String listKey = this.existListKeyInMap(cMap);
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                if (((List)cMap.get(listKey)).size() == 0) {
                    throw new BusinessException("spreadStep data not found,key\uff1a" + listKey);
                }
                if (this.findMapInList((List)cMap.get(listKey))) {
                    for (Object obj : (List)cMap.get(listKey)) {
                        list.addAll(this.enterStruct(listKey, (Map)obj));
                    }
                } else {
                    list.addAll(this.setMapList((List)cMap.get(listKey)));
                }
                Map<String, Object> otherFields = this.spreadObjectInFields(cMap, listKey);
                return this.insteadOf(cMap, list, listKey, otherFields);
            }
            String listKey = this.existMapKeyInMap(cMap);
            List<Map<String, Object>> list = this.enterStruct(listKey, (Map)cMap.get(listKey));
            Map<String, Object> otherFields = this.spreadObjectInFields(cMap, listKey);
            return this.insteadOf(cMap, list, listKey, otherFields);
        }
        ArrayList<Map<String, Object>> rtn = new ArrayList<Map<String, Object>>();
        rtn.add(cMap);
        return rtn;
    }

    public List<Map<String, Object>> setMapList(List<Map<String, Object>> list) {
        ArrayList<Map<String, Object>> rtn = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> obj : list) {
            HashMap<String, Map<String, Object>> field = new HashMap<String, Map<String, Object>>();
            field.put("", obj);
            rtn.add(field);
        }
        return rtn;
    }

    public Map<String, Object> spreadObjectInFields(Map<String, Object> mMap, String listKey) {
        Map<String, Object> rtn;
        Map<String, Object> otherFields = this.getOtherFields(mMap, listKey);
        if (this.findMapInMap(otherFields)) {
            rtn = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : otherFields.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    rtn.putAll(this.setFatherKeyIntoObjectKey(entry.getKey(), (Map)entry.getValue()));
                    continue;
                }
                rtn.put(entry.getKey(), entry.getValue());
            }
        } else {
            rtn = otherFields;
        }
        return rtn;
    }

    public List<Map<String, Object>> insteadOf(Map<String, Object> mMap, List<Map<String, Object>> list, String listKey, Map<String, Object> otherFields) {
        ArrayList<Map<String, Object>> rtn = new ArrayList<Map<String, Object>>(list.size());
        for (Map<String, Object> obj : list) {
            rtn.add(this.concatMap(this.setFatherKeyIntoObjectKey(listKey, obj), otherFields));
        }
        if (list.size() == 0) {
            HashMap<String, Object> tmpMap = new HashMap<String, Object>();
            tmpMap.put(listKey, null);
            rtn.add(this.concatMap(tmpMap, otherFields));
        }
        return rtn;
    }

    public Map<String, Object> concatMap(Map<String, Object> subMap, Map<String, Object> otherFields) {
        subMap.putAll(otherFields);
        return subMap;
    }

    public Map<String, Object> getOtherFields(Map<String, Object> mMap, String cleanKey) {
        HashMap<String, Object> cMap = new HashMap<String, Object>(mMap.size() - 1);
        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (entry.getKey().equals(cleanKey)) continue;
            cMap.put(entry.getKey(), entry.getValue());
        }
        return cMap;
    }

    public boolean findMapInList(List<Object> mList) {
        Object obj;
        Iterator<Object> iterator = mList.iterator();
        return iterator.hasNext() && (obj = iterator.next()) instanceof Map;
    }

    public boolean findListInMap(Map<String, Object> mMap) {
        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (!(entry.getValue() instanceof List)) continue;
            return true;
        }
        return false;
    }

    public boolean findMapInMap(Map<String, Object> mMap) {
        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            return true;
        }
        return false;
    }

    public String existListKeyInMap(Map<String, Object> mMap) {
        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (!(entry.getValue() instanceof List)) continue;
            return entry.getKey();
        }
        return "";
    }

    public String existMapKeyInMap(Map<String, Object> mMap) {
        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            return entry.getKey();
        }
        return "";
    }

    public Map<String, Object> setFatherKeyIntoObjectKey(String fatherKey, Map<String, Object> mMap) {
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : mMap.entrySet()) {
            rtn.put(this.setPathKey(fatherKey, entry.getKey()), entry.getValue());
        }
        return rtn;
    }

    public String setPathKey(String fatherKey, String currentKey) {
        String symbol = ".";
        if (fatherKey.isEmpty() || currentKey.isEmpty()) {
            symbol = "";
        }
        return fatherKey + symbol + currentKey;
    }
}

