package com.digiwin.athena.executionengine.service.facade.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;

import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/9/18
 */
public abstract class AbstractSchemaConvertor implements ISchemaConvertor {


    protected Map<String, String> getReversalShowFieldMapping(JSONObject querySchema) {
        JSONObject showFieldsMapping = querySchema.getJSONObject(FieldNameConstant.DYNAMIC_SCHEMA_SHOWFIELDSMAPPING);
        // k v 反转一下
        Map<String, String> newMap = showFieldsMapping.entrySet().stream().collect(Collectors.toMap(
                entry -> entry.getValue().toString(), entry -> entry.getKey()));
        return newMap;
    }

    protected boolean dimensionsIsExist(JSONObject querySchema, String key) {
        return querySchema.getJSONArray("dimensions").stream().anyMatch(o -> ((JSONObject) o).getString("name").equals(key));
    }
}
