/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Service;

@Service(value="InputAction")
public class InputAction
extends ActionBase {
    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        Map<String, String> filterMap = this.analyseFilterParam(context);
        filterMap.forEach((k, v) -> reqMap.put((String)k, v));
        return reqMap;
    }

    private Map<String, String> analyseFilterParam(ExecuteContext context) {
        JSONObject dynamicSchema = context.getInputParam().getDataDescription().getDynamicSchema();
        JSONObject ds = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dynamicSchema));
        JSONObject jsonObject = ds.getJSONObject("filter");
        HashMap<String, String> filterMap = new HashMap<String, String>();
        if (MapUtils.isEmpty((Map)jsonObject)) {
            return filterMap;
        }
        JSONArray children = jsonObject.getJSONArray("children");
        if (CollectionUtils.isEmpty((Collection)children)) {
            return filterMap;
        }
        children.forEach(item -> {
            JSONObject child = (JSONObject)item;
            JSONObject left = child.getJSONObject("left");
            JSONArray right = child.getJSONArray("right");
            String key = left.getString("content");
            String value = right.getJSONObject(0).getJSONObject("dataObject").getString("content");
            if (!filterMap.containsKey(key)) {
                filterMap.put(key, value);
            } else {
                String v = (String)filterMap.get(key);
                filterMap.put(key, v + "#" + value);
            }
        });
        return filterMap;
    }
}

