/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.core.container.ExecuteErrorMessage;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="MechanismAction")
public class MechanismAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MechanismAction.class);

    @Override
    public Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject metaObj = actionParam.getMetaObj();
        String variableName = metaObj.getString("variableName");
        String eocLevel = metaObj.getString("eocLevel");
        try {
            Map<String, Object> param = this.buildRequestBody(context, variableName, eocLevel);
            LOGGER.info("\u6267\u884c\u5f15\u64ce\u8c03\u7528themeMap\u83b7\u53d6{}\u673a\u5236\u53d8\u91cf\u5165\u53c2:{}", (Object)actionParam.getActionId(), param);
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json;charset=UTF-8");
            header.put("token", context.getToken());
            header.put("security-token", context.getSecurityToken());
            header.put("routerKey", context.getRouterKey());
            String httpRespContent = HttpClientUtils.doRequest("POST", ModuleProperty.THEMEMAP_ACTION_MECHANISM_NEW, header, param);
            LOGGER.info("\u6267\u884c\u5f15\u64ce\u8c03\u7528themeMap\u83b7\u53d6{}\u673a\u5236\u53d8\u91cf\u8fd4\u56de\u7ed3\u679c:{}", (Object)actionParam.getActionId(), (Object)httpRespContent);
            JSONObject respData = ServiceResponseUtils.getThemeMapResp(httpRespContent);
            if (respData == null) {
                context.setExecuteStatus(false);
                return null;
            }
            context.setExecuteStatus(true);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put(variableName, Optional.ofNullable(respData).map(data -> data.get((Object)variableName)).orElse(null));
            return resultMap;
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u83b7\u53d6\u673a\u5236\u53d8\u91cf[{}]\u8c03\u7528\u5f02\u5e38:{}", (Object)variableName, (Object)e);
            ExecuteErrorMessage executeErrorMessage = new ExecuteErrorMessage();
            executeErrorMessage.setErrorMsg(e.getMessage());
            executeErrorMessage.setErrorCode("P.EE.600.0003");
            executeErrorMessage.setActionTypeEnum(ActionTypeEnum.GET_VAR);
            context.setExecuteErrorMessage(executeErrorMessage);
            context.setExecuteStatus(false);
            throw e;
        }
    }

    private Map<String, Object> buildRequestBody(ExecuteContext context, String variableName, String eocLevel) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        HashMap<String, Object> queryData = new HashMap<String, Object>(8);
        queryData.put("variableName", variableName);
        queryData.put("tenantId", context.getTenantId());
        Map<String, Object> eocMap = context.getInputParam().getEocMap();
        if (MapUtils.isNotEmpty(eocMap) && StringUtils.isNotBlank((CharSequence)eocLevel)) {
            queryData.put("eocMap", eocMap);
        }
        if (MapUtils.isNotEmpty(eocMap) && MapUtils.isNotEmpty((Map)((Map)eocMap.get("operation_unit_v2")))) {
            queryData.put("eocMap", eocMap);
        }
        queryData.put("eocLevel", eocLevel);
        result.put("queryData", queryData);
        return result;
    }
}

