/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.core.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TableNameHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.digiwin.athena.executionengine.core.holder.RecordTableNameHandler;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(value={"com.digiwin.athena.executionengine.repository"}, sqlSessionTemplateRef="engineSqlSessionTemplate")
public class EngineMyBatisPlusConfig {
    private static final String[] TABLE_NAME_ADD_MONTH = new String[0];

    @Bean(value={"engineDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.engine")
    public DruidDataSource engineDataSource() {
        return DruidDataSourceBuilder.create().build();
    }

    @Primary
    @Bean(name={"engineExecutionSessionFactory"})
    public SqlSessionFactory createSqlSession(@Qualifier(value="engineDataSource") DataSource source) throws Exception {
        MybatisSqlSessionFactoryBean factoryBean = new MybatisSqlSessionFactoryBean();
        factoryBean.setDataSource(source);
        factoryBean.setConfiguration(this.engineMybatisConfiguration());
        factoryBean.setGlobalConfig(this.globalConfig());
        factoryBean.setPlugins(new Interceptor[]{this.engineMybatisPlusInterceptor()});
        return factoryBean.getObject();
    }

    @Bean(value={"engineMybatisConfiguration"})
    public MybatisConfiguration engineMybatisConfiguration() {
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setMapUnderscoreToCamelCase(true);
        return configuration;
    }

    private GlobalConfig globalConfig() {
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setDbConfig(this.dbConfig());
        return globalConfig;
    }

    private GlobalConfig.DbConfig dbConfig() {
        return new GlobalConfig.DbConfig();
    }

    @Bean(value={"engineMybatisPlusInterceptor"})
    public MybatisPlusInterceptor engineMybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        DynamicTableNameInnerInterceptor dynamicTableNameInnerInterceptor = new DynamicTableNameInnerInterceptor();
        dynamicTableNameInnerInterceptor.setTableNameHandler((TableNameHandler)new RecordTableNameHandler(TABLE_NAME_ADD_MONTH));
        interceptor.addInnerInterceptor((InnerInterceptor)dynamicTableNameInnerInterceptor);
        interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)new BlockAttackInnerInterceptor());
        return interceptor;
    }

    @Bean(name={"engineTransactionManager"})
    @Primary
    public DataSourceTransactionManager engineTransactionManager(@Qualifier(value="engineDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"engineSqlSessionTemplate"})
    @Primary
    public SqlSessionTemplate engineSqlSessionTemplate(@Qualifier(value="engineExecutionSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

