/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.provider;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.dto.ErrorLog;
import com.digiwin.athena.executionengine.exception.BusinessException;
import com.digiwin.athena.executionengine.model.ServiceResult;
import com.digiwin.athena.executionengine.provider.ITransService;
import com.digiwin.athena.executionengine.service.facade.execution.IExecutionFacade;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;
import com.digiwin.athena.executionengine.service.srp.ITransSrp;
import com.digiwin.athena.executionengine.util.DateUtils;
import com.digiwin.athena.executionengine.util.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="engineTransService")
public class TransService
implements ITransService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransService.class);
    @Autowired
    private ITransSrp transSrp;
    @Autowired
    private IExecutionFacade executeFacade;

    @Override
    public Object postRunTrans(String tenantId, String ruleId, Map<String, Object> param) {
        ServiceResult serviceResult = this.transSrp.runTrans(tenantId, ruleId, param, null);
        return serviceResult.getData();
    }

    @Override
    public Object postRunTrans(List<Map<String, Object>> recasts, Object data, String tenantId) {
        ServiceResult serviceResult;
        JSONObject json = new JSONObject(3);
        json.put("tenantId", (Object)tenantId);
        json.put("recasts", recasts);
        json.put("data", data);
        String source = (String)DWServiceContext.getContext().getRequestHeader().get("source");
        LOGGER.info(String.format("\u4e8c\u6b21\u8ba1\u7b97\u5165\u53c2:%s", JSONObject.toJSONString((Object)json)));
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            LOGGER.error(String.format("agiledata_%s_\u4e8c\u6b21\u8ba1\u7b97\u5165\u53c2:%s", source, JSONObject.toJSONString(recasts)));
        }
        if ((serviceResult = this.transSrp.runTrans(tenantId, recasts, data)).getData() != null && serviceResult.getData() instanceof List) {
            if (CollectionUtils.isEmpty((Collection)((List)serviceResult.getData()))) {
                ErrorLog errorLog = new ErrorLog();
                errorLog.setErrorCode("U.EE.500.0007");
                errorLog.setErrorLocation("\u6570\u636e\u62c9\u53d6\u4e8c\u6b21\u8ba1\u7b97");
                errorLog.setErrorDescription("\u4e8c\u6b21\u8ba1\u7b97\u6761\u4ef6\u8fc7\u6ee4\u540e\uff0c\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e");
                errorLog.setErrorTimestamp(DateUtils.getCurrentDateTime());
                errorLog.setErrorMessage("[\u62c9\u53d6\u5230\u7684\u6570\u636e]\u4ee5\u53ca[\u4e8c\u6b21\u8fc7\u6ee4\u6761\u4ef6]");
                errorLog.setPossibleCausesAndGuidance("\u8fc7\u6ee4\u6761\u4ef6\u8bbe\u5b9a\u4e0d\u6b63\u786e\u6216\u8005\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u76f8\u5173\u7684\u6570\u636e");
                LogUtils.buildAgileLog("recastFilterData", LogUtils.WARING, "\u4e8c\u6b21\u8ba1\u7b97\u5165\u53c2\uff1a" + JSONObject.toJSONString(recasts), "\u4e8c\u6b21\u8ba1\u7b97\u6761\u4ef6\u8fc7\u6ee4\u540e\uff0c\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\uff0c\u53ef\u80fd\u662f1.\u771f\u7684\u6ca1\u6709\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\u7684\u6570\u636e\u30022.\u6570\u636e\u6d41\u4e2djoin\u6b65\u9aa4\u6570\u636e\u4e0d\u6b63\u5e38", "1.\u6253\u5f00\u573a\u666f\u914d\u7f6e\u754c\u9762\uff0c\u627e\u5230\u573a\u666f\u4e2d\u7684\u8fc7\u6ee4\u914d\u7f6e\u3002\n2.\u68c0\u67e5\u8fc7\u6ee4\u6761\u4ef6\uff0c\u786e\u8ba4\u5176\u903b\u8f91\u8fd0\u7b97\u7b26\u3001\u6bd4\u8f83\u503c\u7b49\u662f\u5426\u6b63\u786e\u3002\n3.\u8c03\u6574\u8fc7\u6ee4\u8bbe\u7f6e\uff0c\u4fdd\u5b58\u5e76\u91cd\u65b0\u53d1\u7248\u3002\n4.\u53bb\u5730\u7aef\u6267\u884cSQL\u68c0\u67e5\u6570\u636e\u7684\u683c\u5f0f\u662f\u5426\u4e00\u81f4\n5.\u82e5\u95ee\u9898\u672a\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u5e76\u63d0\u4f9b\u573a\u666fcode\u3002");
                LOGGER.error(String.format("agiledata_%s_\u4e8c\u6b21\u8ba1\u7b97\u51fa\u53c2:%s", source, errorLog.toString()));
                throw new BusinessException(errorLog.getErrorCode(), errorLog.toString());
            }
        } else {
            serviceResult.setData(new ArrayList());
        }
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            LOGGER.error(String.format("agiledata_%s_\u4e8c\u6b21\u8ba1\u7b97\u51fa\u53c2:%s", source, JSONObject.toJSONString((Object)serviceResult.getData())));
        }
        return serviceResult.getData();
    }

    @Override
    public Object postRunTrans(List<Map<String, Object>> recasts, Object data, String actionId, String tenantId) {
        Object obj = this.postRunTrans(recasts, data, tenantId);
        Object meta = this.executeFacade.generateMetaHandler(new DataMappingManager(obj), actionId, tenantId);
        JSONObject result = new JSONObject();
        result.put("meta", meta);
        result.put("data", obj);
        return result;
    }
}

