/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.dto.ErrorLog;
import com.digiwin.athena.executionengine.exception.BusinessException;
import com.digiwin.athena.executionengine.service.client.IThemeMapClient;
import com.digiwin.athena.executionengine.util.DateUtils;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.LogUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="engineThemeMapClient")
public class ThemeMapClient
implements IThemeMapClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IThemeMapClient.class);

    @Override
    public JSONObject getExecutionRule(String actionId, String tenantId, Set<String> paramKeys, Set<String> sysParamKeys, String token) {
        HashMap<String, String> headerMap = new HashMap<String, String>(2);
        headerMap.put("token", token);
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        headerMap.put("locale", (String)DWServiceContext.getContext().getRequestHeader().get("locale"));
        headerMap.put("routerKey", String.valueOf(DWServiceContext.getContext().getRequestHeader().get("routerKey")));
        headerMap.put("security-token", (String)DWServiceContext.getContext().getRequestHeader().get("security-token"));
        HashMap<String, Object> reqMap = new HashMap<String, Object>(4);
        reqMap.put("actionId", actionId);
        reqMap.put("tenantId", tenantId);
        reqMap.put("existingActionParams", paramKeys);
        reqMap.put("existingSysParams", sysParamKeys);
        String input = JSON.toJSONString(reqMap);
        LOGGER.info("\u8c03\u7528themeMap\u83b7\u53d6\u884c\u52a8\u903b\u8f91\u7684\u5165\u53c2:{}", (Object)input);
        String source = (String)DWServiceContext.getContext().getRequestHeader().get("source");
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            LOGGER.error(String.format("agiledata_%s_\u8c03\u7528KM\u5165\u53c2:%s", "executionengine", JSON.toJSONString(reqMap)));
        }
        String httpContent = null;
        try {
            httpContent = HttpClientUtils.doPost(ModuleProperty.THEMEMAP_ACTION_QUERYEXECUTIONPATH, headerMap, JSON.toJSONString(reqMap));
        }
        catch (Exception e) {
            ErrorLog errorLog = new ErrorLog();
            errorLog.setErrorCode("U.EE.500.0005");
            errorLog.setErrorLocation("\u83b7\u53d6\u6570\u636e\u6d41\u914d\u7f6e\uff0c\u6570\u636e\u6d41id:" + actionId);
            errorLog.setErrorDescription("\u6570\u636e\u6d41\u4e0d\u5b58\u5728");
            errorLog.setErrorTimestamp(DateUtils.getCurrentDateTime());
            errorLog.setErrorMessage(String.format("\u6570\u636e\u6d41id::%s\u5728\u56fe\u8c31\u4e2d\u4e0d\u5b58\u5728", actionId));
            errorLog.setPossibleCausesAndGuidance("\u8bf7\u786e\u8ba4\u5f53\u524d\u662f\u5426\u6b63\u5728\u53d1\u7248\uff0c\u6216\u8be5\u6570\u636e\u6d41\u662f\u5426\u88ab\u8bef\u5220\u9664");
            LOGGER.error(String.format("agiledata_%s_\u8c03\u7528KM\u51fa\u53c2:%s", source, errorLog.toString()));
            LogUtils.buildAgileLog("queryExecutionRule", "U.EE.500.0005", input, "\u83b7\u53d6\u884c\u52a8\u6267\u884c\u8def\u5f84\u5931\u8d25\uff0c\u53ef\u80fd\u7684\u539f\u56e0\u662f\uff1a\u5f00\u53d1\u5e73\u53f0\u6b63\u5728\u53d1\u7248\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010" + e.getMessage() + "\u3011", "\"1.\u767b\u5f55\u5f00\u53d1\u5e73\u53f0\u7684\u7ba1\u7406\u9762\u677f\uff0c\u67e5\u770b\u7cfb\u7edf\u7684\u66f4\u65b0\u6216\u53d1\u7248\u65e5\u5fd7\uff0c\u68c0\u67e5\u63d0\u95ee\u65f6\u662f\u5426\u6b63\u5728\u53d1\u7248\u3002\n2.\u82e5\u6b63\u5728\u53d1\u7248\uff0c\u7b49\u5f85\u53d1\u7248\u5b8c\u6210\u3002\n3.\u53d1\u7248\u5b8c\u6210\u540e\uff0c\u91cd\u65b0\u5c1d\u8bd5\u67e5\u8be2\u6307\u6807\u3002\n4.\u82e5\u95ee\u9898\u6301\u7eed\uff0c\u8bb0\u5f55\u5f53\u524d\u64cd\u4f5c\u6b65\u9aa4\u3001\u4f7f\u7528\u7684\u67e5\u8be2\u6761\u4ef6\u548c\u9519\u8bef\u4fe1\u606f\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002\"");
            throw new BusinessException(errorLog.getErrorCode(), errorLog.toString());
        }
        LOGGER.info("ThemeMap\u8fd4\u56de\u884c\u52a8\u903b\u8f91\u7684\u5185\u5bb9:{}", (Object)httpContent);
        LogUtils.buildAgileLog("queryExecutionRule", LogUtils.SUCCESS, input, httpContent, "");
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            LOGGER.error(String.format("agiledata_%s_\u8c03\u7528KM\u51fa\u53c2:%s", "executionengine", httpContent));
        }
        return Optional.ofNullable(httpContent).map(ServiceResponseUtils::getThemeMapResp).orElse(null);
    }

    @Override
    public JSONObject getUIMetaData(String actionId, String token, String tenantId, String locale) {
        HashMap<String, String> headerMap = new HashMap<String, String>(2);
        headerMap.put("token", token);
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        headerMap.put("locale", locale);
        headerMap.put("routerKey", String.valueOf(DWServiceContext.getContext().getRequestHeader().get("routerKey")));
        headerMap.put("security-token", (String)DWServiceContext.getContext().getRequestHeader().get("security-token"));
        HashMap<String, Object> reqMap = new HashMap<String, Object>(4);
        reqMap.put("actionId", actionId);
        reqMap.put("tenantId", tenantId);
        reqMap.put("existingActionParams", Collections.EMPTY_LIST);
        reqMap.put("existingSysParams", Collections.EMPTY_LIST);
        LOGGER.info("\u8c03\u7528themeMap\u83b7\u53d6\u7528\u4e8e\u5c55\u793a\u754c\u9762\u7684\u5143\u6570\u636e:{}", (Object)JSON.toJSONString(reqMap));
        String httpContent = HttpClientUtils.doPost(ModuleProperty.THEMEMAP_ACTION_QUERYEXECUTIONPATH, headerMap, JSON.toJSONString(reqMap));
        LOGGER.info("ThemeMap\u8fd4\u56de\u5143\u6570\u636e:{}", (Object)httpContent);
        return Optional.ofNullable(httpContent).map(ServiceResponseUtils::getThemeMapResp).orElse(null);
    }

    @Override
    public JSONObject getExecutionRules(String tenantId, List<String> actionIds, String token) {
        return null;
    }

    @Override
    public JSONObject querySmartDataVariable(String tenantId, List<String> variableIds, String token) {
        HashMap<String, String> headerMap = new HashMap<String, String>(2);
        headerMap.put("token", token);
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        String routerKey = String.valueOf(DWServiceContext.getContext().getRequestHeader().get("routerKey"));
        headerMap.put("routerKey", StringUtils.isEmpty((CharSequence)routerKey) || "null".equalsIgnoreCase(routerKey) ? tenantId : routerKey);
        headerMap.put("security-token", (String)DWServiceContext.getContext().getRequestHeader().get("security-token"));
        HashMap<String, Object> reqMap = new HashMap<String, Object>(4);
        reqMap.put("variableIds", variableIds);
        reqMap.put("tenantId", tenantId);
        LOGGER.info(String.format("agiledata_%s_\u83b7\u53d6\u4e1a\u52a1\u53d8\u91cf\u7684\u5165\u53c2:%s header:%s ", "querySmartDataVariable", JSON.toJSONString(reqMap), JSON.toJSONString(headerMap)));
        String httpContent = HttpClientUtils.doPost(ModuleProperty.THEMEMAP_ACTION_QUERYSMARTDATAVARIABLE, headerMap, JSON.toJSONString(reqMap));
        LOGGER.info(String.format("agiledata_%s_\u83b7\u53d6\u4e1a\u52a1\u53d8\u91cf\u7684\u51fa\u53c2:%s header:%s ", "querySmartDataVariable", httpContent, JSON.toJSONString(headerMap)));
        return Optional.ofNullable(httpContent).map(ServiceResponseUtils::getThemeMapResp).orElse(null);
    }

    @Override
    public JSONObject queryMetricQuerySchema(Set<String> metricIds) {
        HashMap<String, String> headerMap = new HashMap<String, String>(2);
        String token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        headerMap.put("token", token);
        headerMap.put("locale", locale);
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        headerMap.put("routerKey", String.valueOf(DWServiceContext.getContext().getRequestHeader().get("routerKey")));
        headerMap.put("security-token", (String)DWServiceContext.getContext().getRequestHeader().get("security-token"));
        HashMap<String, Set<String>> reqMap = new HashMap<String, Set<String>>(4);
        reqMap.put("indicatorIds", metricIds);
        LOGGER.info("\u8c03\u7528themeMap\u83b7\u53d6\u884c\u52a8\u903b\u8f91\u7684\u5165\u53c2:{}", (Object)JSON.toJSONString(reqMap));
        String source = (String)DWServiceContext.getContext().getRequestHeader().get("source");
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            LOGGER.error(String.format("agiledata_%s_\u8c03\u7528KM\u5165\u53c2:%s", "executionengine", JSON.toJSONString(reqMap)));
        }
        String httpContent = null;
        try {
            httpContent = HttpClientUtils.doPost(ModuleProperty.THEMEMAP_ACTION_METRICQUERYSCHEMA, headerMap, JSON.toJSONString(reqMap));
        }
        catch (Exception e) {
            LOGGER.error("post queryMetricQuerySchema error", (Throwable)e);
        }
        LOGGER.info("ThemeMap\u8fd4\u56de\u6307\u6807\u4e0b\u7684querySchema\u7684\u5185\u5bb9:{}", (Object)httpContent);
        return Optional.ofNullable(httpContent).map(ServiceResponseUtils::getThemeMapResp).orElse(null);
    }
}

