/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.complement.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.executionengine.model.DataItem;
import com.digiwin.athena.executionengine.model.IncrementalDefinition;
import com.digiwin.athena.executionengine.service.facade.complement.IDataComplement;
import com.digiwin.athena.executionengine.util.DateUtils;
import com.digiwin.athena.executionengine.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="dataComplement")
public class DataComplement
implements IDataComplement {
    @Override
    public void replenish(IncrementalDefinition incrementalDefinition, Object valueMap, List<Map<String, Object>> apiParams) {
        Map dataMap = (Map)valueMap;
        Object data = dataMap.get("data");
        if (!(data instanceof List)) {
            return;
        }
        String dateFormat = incrementalDefinition.getGranularity();
        Set<String> timeList = this.calTimeList(incrementalDefinition.getIncrease(), dateFormat, apiParams);
        List dataList = (List)data;
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        JSONArray dataArray = (JSONArray)JSON.toJSON((Object)dataList);
        List<String> missingDates = this.findMissingMonths((List<Object>)dataArray, timeList, incrementalDefinition.getMissingField());
        List<DataItem> dataItems = this.analyseMetaData((List<Object>)dataArray);
        List<Map> completedData = JsonUtil.getList(JsonUtil.getJsonString(dataList), Map.class);
        missingDates.forEach(item -> {
            HashMap<String, String> map = new HashMap<String, String>();
            dataItems.forEach(dataItem -> map.put(dataItem.getName(), (String)this.getValue(dataItem.getType())));
            map.put(incrementalDefinition.getMissingField(), (String)item);
            completedData.add(map);
        });
        completedData.sort(Comparator.comparing(item -> (String)item.get(incrementalDefinition.getMissingField())));
        dataMap.put("data", completedData);
    }

    private Object getValue(String type) {
        if ("string".equalsIgnoreCase(type)) {
            return "";
        }
        if ("number".equalsIgnoreCase(type)) {
            return 0;
        }
        return "";
    }

    private List<String> findMissingMonths(List<Object> dataList, Set<String> timeList, String missingField) {
        HashSet srcDateSet = new HashSet();
        dataList.forEach(item -> srcDateSet.add((String)((Map)item).get(missingField)));
        return timeList.stream().filter(item -> !srcDateSet.contains(item)).collect(Collectors.toList());
    }

    private List<DataItem> analyseMetaData(List<Object> dataList) {
        Map map = (Map)dataList.get(0);
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        map.forEach((k, v) -> dataItems.add(new DataItem((String)k, this.getType(v))));
        return dataItems;
    }

    private String getType(Object v) {
        if (v instanceof Number) {
            return "number";
        }
        return "string";
    }

    private Set<String> calTimeList(String increase, String dateFormat, List<Map<String, Object>> apiParams) {
        Map<String, Object> inputParam = apiParams.get(0);
        String date = (String)inputParam.get(increase);
        String[] times = date.split("#");
        return DateUtils.getTimeListByBetweenTime(times[0], times[1], dateFormat);
    }
}

