/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.convert.trans;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.exception.CustomException;
import com.digiwin.athena.executionengine.service.facade.convert.trans.ICriteriaTransformer;
import java.util.ArrayList;
import org.springframework.stereotype.Service;

@Service
public class CalculateTransformer
implements ICriteriaTransformer {
    @Override
    public JSONObject analysisVariable(JSONObject schema) {
        JSONObject variable = new JSONObject();
        variable.put("technique", (Object)"calculate");
        JSONArray rule = schema.getJSONArray("rule");
        boolean match = rule.stream().allMatch(obj -> "WEEKOFYEAROFDATE,ADD,ABS,MINUS,MULTIPLY,DIVIDE,DATEDIFFINDAYS,NUMBEROFINTERVALBYDAY,PRECISION,FORMATDATE,ROOTING,POWER,GROWTHRATE,DATEFORMAT".contains(((JSONObject)obj).getString("calFunction").toUpperCase()));
        if (!match) {
            throw new CustomException("\u5b58\u5728\u4e0d\u652f\u6301\u7684\u8ba1\u7b97\u65b9\u6cd5rule:" + rule);
        }
        ArrayList calRules = new ArrayList(rule.size());
        rule.forEach(obj -> {
            JSONObject ruleObj = (JSONObject)obj;
            String method = ruleObj.getString("calFunction");
            calRules.add(this.genCalRule(method, ruleObj));
        });
        variable.put("rule", calRules);
        return variable;
    }

    private JSONObject genCalRule(String method, JSONObject ruleObj) {
        switch (method) {
            case "Add": 
            case "Minus": 
            case "Multiply": {
                return this.genCommonRule(ruleObj);
            }
            case "Divide": {
                JSONObject rule = this.genCommonRule(ruleObj);
                rule.put("precision", (Object)6);
                return rule;
            }
            case "Abs": {
                return this.genAbsRule(ruleObj);
            }
            case "DateFormat": {
                return this.genDateFormatRule(ruleObj);
            }
            case "GrowthRate": {
                return this.genGrowthRateRule(ruleObj);
            }
        }
        return null;
    }

    private JSONObject genGrowthRateRule(JSONObject ruleObj) {
        String method = ruleObj.getString("calFunction");
        String valueType = ruleObj.getString("valueType");
        String newField = ruleObj.getString("newField");
        JSONArray param = ruleObj.getJSONArray("params");
        JSONObject rule = new JSONObject();
        rule.put("calcType", (Object)method);
        rule.put("fieldA", (Object)param.getJSONObject(0).getString("content"));
        rule.put("fieldB", (Object)param.getJSONObject(1).getString("content"));
        rule.put("fieldA_type", (Object)"column");
        rule.put("fieldB_type", (Object)"column");
        rule.put("newField", (Object)newField);
        rule.put("valueType", (Object)valueType);
        rule.put("retain", (Object)true);
        return rule;
    }

    private JSONObject genDateFormatRule(JSONObject ruleObj) {
        String method = ruleObj.getString("calFunction");
        String valueType = ruleObj.getString("valueType");
        String newField = ruleObj.getString("newField");
        JSONArray param = ruleObj.getJSONArray("params");
        JSONObject rule = new JSONObject();
        rule.put("calcType", (Object)method);
        rule.put("fieldA", (Object)param.getJSONObject(0).getString("content"));
        rule.put("formatA", (Object)param.getJSONObject(1).getString("content"));
        rule.put("newField", (Object)newField);
        rule.put("valueType", (Object)valueType);
        rule.put("retain", (Object)true);
        return rule;
    }

    private JSONObject genCommonRule(JSONObject ruleObj) {
        String method = ruleObj.getString("calFunction");
        String valueType = ruleObj.getString("valueType");
        String newField = ruleObj.getString("newField");
        JSONArray param = ruleObj.getJSONArray("params");
        JSONObject rule = new JSONObject();
        rule.put("calcType", (Object)method);
        rule.put("fieldA", (Object)param.getJSONObject(0).getString("content"));
        rule.put("fieldB", (Object)param.getJSONObject(1).getString("content"));
        rule.put("newField", (Object)newField);
        rule.put("valueType", (Object)valueType);
        rule.put("retain", (Object)true);
        return rule;
    }

    private JSONObject genAbsRule(JSONObject ruleObj) {
        String method = ruleObj.getString("calFunction");
        String valueType = ruleObj.getString("valueType");
        String newField = ruleObj.getString("newField");
        String precision = ruleObj.getString("precision");
        String precisionType = ruleObj.getString("precisionType");
        JSONArray param = ruleObj.getJSONArray("param");
        JSONObject rule = new JSONObject();
        rule.put("calcType", (Object)method);
        rule.put("fieldA", (Object)param.getJSONObject(0).getString("content"));
        rule.put("newField", (Object)newField);
        rule.put("valueType", (Object)valueType);
        rule.put("precision", (Object)precision);
        rule.put("precisionType", (Object)precisionType);
        rule.put("retain", (Object)true);
        return rule;
    }
}

