/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.event;

import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.service.facade.event.ActionEvent;
import com.digiwin.athena.executionengine.service.facade.execution.asyc.AsyncExecutor;
import com.digiwin.athena.executionengine.util.ContextUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActionEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void handleActionEvent(ActionEvent event) {
        String source = event.getActionId();
        ExecuteContext context = event.getContext();
        Set<String> pActionIds = context.getActionQueue().getNode(source);
        Map<String, String> line = context.getLine();
        String pre = line.get(source);
        pActionIds.forEach(k -> {
            String tempLine = pre == null ? source + "--->" + k : pre + "--->" + k;
            line.put((String)k, tempLine);
            LOGGER.info("stepLine:{}", (Object)tempLine);
            ActionBase actionBase = Optional.ofNullable(context.getActionParam((String)k)).map(ap -> ContextUtils.getBean(ap.getActionName(), ActionBase.class)).orElse(null);
            actionBase.prepare(context, context.getActionParam((String)k));
        });
        if (CollectionUtils.isEmpty(pActionIds)) {
            ExecuteContext executeContext = context;
            synchronized (executeContext) {
                context.notify();
            }
        }
    }
}

