/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.execution.asyc;

import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.ResultStatusConstant;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.ExceptionUtils;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncTask.class);
    private ActionParam actionParam;
    private volatile ExecuteContext context;
    private boolean canExec = true;

    public AsyncTask(ExecuteContext context, ActionParam actionParam) {
        this.context = context;
        this.actionParam = actionParam;
    }

    public AsyncTask(ExecuteContext context, ActionParam actionParam, boolean canExec) {
        this.context = context;
        this.actionParam = actionParam;
        this.canExec = canExec;
    }

    public void exec() {
        if (!this.canExec) {
            this.actionParam.setActionState(ResultStatusConstant.EXECUTE_FAILD.getCode());
            LOGGER.info("{} \u4e0d\u80fd\u6267\u884c\uff0c\u9ed8\u8ba4\u5931\u8d25:{}", (Object)this.actionParam.getActionId(), (Object)this.actionParam.getActionState());
            return;
        }
        ActionBase actionBase = Optional.ofNullable(this.context.getActionParam(this.actionParam.getActionId())).map(ap -> ContextUtils.getBean(ap.getActionName(), ActionBase.class)).orElse(null);
        if (null == actionBase) {
            throw ExceptionUtils.buildBusinessException(ErrorCodeEnum.ACTION_NOT_FOUND, this.actionParam.getActionId());
        }
        try {
            boolean flag = actionBase.exec(this.context, this.actionParam);
            LOGGER.info("--actionId:{}----------exec-----------{}", (Object)this.actionParam.getActionId(), (Object)flag);
            if (flag) {
                this.actionParam.setActionState(ResultStatusConstant.EXECUTE_SUCCESS.getCode());
            } else {
                this.actionParam.setActionState(ResultStatusConstant.EXECUTE_FAILD.getCode());
            }
        }
        catch (Exception e) {
            LOGGER.error("--actionId:{}----------exec-------excetion", (Object)this.actionParam.getActionId(), (Object)e);
            this.actionParam.setActionState(ResultStatusConstant.EXECUTE_FAILD.getCode());
        }
        LOGGER.info("{} \u6267\u884c\u5b8c\u6210\uff0c\u6267\u884c\u7ed3\u679c:{}", (Object)this.actionParam.getActionId(), (Object)this.actionParam.getActionState());
    }

    public ExecuteContext getExecuteContext() {
        return this.context;
    }

    public ActionParam getActionParam() {
        return this.actionParam;
    }
}

