/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.digiwin.athena.executionengine.model.trans.CollectCondition;
import com.digiwin.athena.executionengine.model.trans.DealResult;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.util.AnalysisUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="polymerize")
public class CollectStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectStep.class);

    @Override
    public boolean defineCheck(StepElement stepElement) {
        return true;
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        try {
            Object inputData = this.getCurrentData(step.getPrevStepNameList());
            if (!(inputData instanceof List)) {
                LOGGER.warn("\u805a\u5408\u7ec4\u4ef6\u53ea\u80fd\u63a5\u53d7\u8868\u72b6\u6570\u636e\uff0c\u975e\u5c55\u5e73\u6570\u636e\u9700\u8981\u5148\u6267\u884c\u5c55\u5e73\u8282\u70b9\uff01Trans\u6267\u884c {} \u5931\u8d25\uff0c\u6570\u636e\u7ed3\u6784\u9519\u8bef\uff01", (Object)step.getName());
                dealResult.setDataNullFail();
                return dealResult;
            }
            ArrayList dataList = (ArrayList)inputData;
            if (CollectionUtils.isEmpty((Collection)dataList)) {
                dealResult.setSuccess(Lists.newArrayList());
                return dealResult;
            }
            StepElement stepElement = step.getStepElement();
            List<CollectCondition> collectConditionList = stepElement.getCollectConditions();
            if (CollectionUtils.isEmpty(collectConditionList)) {
                if (stepElement.isTruncateKey()) {
                    ArrayList res = new ArrayList();
                    for (Map map2 : dataList) {
                        HashMap newRecord = new HashMap();
                        for (String key : map2.keySet()) {
                            newRecord.put(AnalysisUtils.truncateKey(key), map2.get(key));
                        }
                        res.add(newRecord);
                    }
                    dealResult.setSuccess(res);
                } else {
                    dealResult.setSuccess(dataList);
                }
                return dealResult;
            }
            for (CollectCondition condition : collectConditionList) {
                if (StringUtils.isBlank((CharSequence)condition.getNewField())) continue;
                List<String> list = condition.getFileds();
                Map<String, List<Map>> groupMap = dataList.stream().collect(Collectors.groupingBy(map -> {
                    StringBuilder builder = new StringBuilder();
                    filedList.forEach(item -> builder.append(map.get(item)));
                    return builder.toString();
                }));
                ArrayList rootList = new ArrayList();
                for (Map.Entry<String, List<Map>> entry : groupMap.entrySet()) {
                    HashMap rowMap = new HashMap();
                    ArrayList<Object> rowElementList = new ArrayList<Object>();
                    for (Map data : entry.getValue()) {
                        HashMap elementMap = new HashMap();
                        for (Map.Entry entryData : data.entrySet()) {
                            String key;
                            if (list.contains(entryData.getKey())) {
                                key = stepElement.isTruncateKey() ? AnalysisUtils.truncateKey((String)entryData.getKey()) : (String)entryData.getKey();
                                rowMap.put(key, entryData.getValue());
                                continue;
                            }
                            if ("value".equals(condition.getType())) {
                                rowElementList.add(entryData.getValue());
                                continue;
                            }
                            key = stepElement.isTruncateKey() ? AnalysisUtils.truncateKey((String)entryData.getKey()) : (String)entryData.getKey();
                            elementMap.put(key, entryData.getValue());
                        }
                        rowElementList.add(elementMap);
                    }
                    if (CollectionUtils.isNotEmpty(rowElementList)) {
                        rowMap.put(condition.getNewField(), rowElementList);
                    }
                    rootList.add(rowMap);
                }
                dataList = rootList;
            }
            dealResult.setSuccess(dataList);
            return dealResult;
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u805a\u5408\u7ec4\u4ef6\u51fa\u73b0\u5f02\u5e38");
            throw e;
        }
    }
}

