/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.model.trans.DealResult;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="mechanism")
public class MechanismStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(MechanismStep.class);

    @Override
    public boolean defineCheck(StepElement stepElement) {
        return true;
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        StepElement stepElement = step.getStepElement();
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json;charset=UTF-8");
            header.put("token", this.getTransDataManager().getToken());
            header.put("routerKey", this.getTransDataManager().getTenantId());
            header.put("security-token", (String)DWServiceContext.getContext().getRequestHeader().get("security-token"));
            Map<String, Object> param = this.buildRequestBody(stepElement.getVariableName(), stepElement.getEocLevel());
            LOGGER.info("\u6267\u884c\u5f15\u64ce\u8c03\u7528themeMap\u83b7\u53d6\u673a\u5236\u53d8\u91cf\u5165\u53c2:{}", param);
            String httpRespContent = HttpClientUtils.doRequest("POST", ModuleProperty.THEMEMAP_ACTION_MECHANISM_NEW, header, param);
            LOGGER.info("\u6267\u884c\u5f15\u64ce\u8c03\u7528themeMap\u83b7\u53d6\u673a\u5236\u53d8\u91cf\u8fd4\u56de\u7ed3\u679c:{}", (Object)httpRespContent);
            JSONObject respData = ServiceResponseUtils.getThemeMapResp(httpRespContent);
            if (respData == null) {
                dealResult.setDataNullFail();
                return dealResult;
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put(stepElement.getVariableName(), Optional.ofNullable(respData).map(data -> data.get((Object)stepElement.getVariableName())).orElse(null));
            this.getTransDataManager().setMechanismData(resultMap);
            dealResult.setSuccess(this.getCurrentData(step.getPrevStepNameList()));
            return dealResult;
        }
        catch (Exception e) {
            LOGGER.error("\u673a\u5236\u53d8\u91cf\u7ec4\u4ef6\u83b7\u53d6\u673a\u5236\u53d8\u91cf\u5f02\u5e38");
            throw e;
        }
    }

    private Map<String, Object> buildRequestBody(String variableName, String eocLevel) {
        TransDataManger transDataManager = this.getTransDataManager();
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        HashMap<String, Object> queryData = new HashMap<String, Object>(8);
        queryData.put("variableName", variableName);
        queryData.put("tenantId", transDataManager.getTenantId());
        Map<String, Object> eocMap = transDataManager.getEocMap();
        if (MapUtils.isNotEmpty(eocMap) && StringUtils.isNotBlank((CharSequence)eocLevel)) {
            queryData.put("eocMap", eocMap);
        }
        if (MapUtils.isNotEmpty(eocMap) && MapUtils.isNotEmpty((Map)((Map)eocMap.get("operation_unit_v2")))) {
            queryData.put("eocMap", eocMap);
        }
        queryData.put("eocLevel", eocLevel);
        result.put("queryData", queryData);
        return result;
    }
}

