/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.util;

import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.model.mq.ExceptionMessageDto;
import com.digiwin.athena.executionengine.model.mq.SuccessMessageDto;
import com.digiwin.athena.executionengine.mq.producer.RabbitMqProducer;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.DateUtils;
import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqSendUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqSendUtils.class);

    public static void sendExceptionMessage(ExecuteContext context, String exceptionMessage) {
        String traceId = DWServiceChainContext.getContext().getTraceElement().getRoot().getId();
        String sessionId = DWServiceChainContext.getContext().getId();
        String parentSessionId = DWServiceChainContext.getContext().getParentId();
        String createdTime = DateUtils.getCurrentDateTime();
        LOGGER.debug("alarm");
        String pinpointId = ThreadContext.get((String)"PtxId");
        ExceptionMessageDto exceptionMessageDto = new ExceptionMessageDto(traceId, context.getTenantId(), pinpointId, sessionId, parentSessionId, exceptionMessage, createdTime, context.getCurrentActionId());
        LOGGER.info("\u53d1\u9001\u5f02\u5e38\u6d88\u606f:{}", (Object)exceptionMessageDto);
        try {
            ContextUtils.getBean(RabbitMqProducer.class, new Object[0]).sendMessage(exceptionMessageDto, "mon.error");
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001\u5f02\u5e38\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public static void sendSuccessMessage(ExecuteContext context, String actionType, Map<String, Object> param) {
        String traceId = DWServiceChainContext.getContext().getTraceElement().getRoot().getId();
        int state = context.isExecuteStatus() ? 1 : 0;
        ArrayList<Map<String, Object>> processEntities = new ArrayList<Map<String, Object>>();
        processEntities.add(param);
        String createdTime = DateUtils.getCurrentDateTime();
        SuccessMessageDto successMessageDto = new SuccessMessageDto(traceId, context.getTenantId(), state, actionType, processEntities, createdTime);
        try {
            ContextUtils.getBean(RabbitMqProducer.class, new Object[0]).sendMessage(successMessageDto, "mon.execution");
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001\u6210\u529f\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

