package com.digiwin.athena.executionengine.constant;

/**
 * @description: themeMap元数据结构常量字段
 * @author: renwm
 * @date: 2020/6/15 14:17
 */
public final class MetaDataConstant {

    /**
     * 服务编排相关常量
     */
    public static final String SERVICE_COMPOSER_ID = "serviceComposerId";
    public static final String ASYNC_COMPLETE = "asyncComplete";

    private MetaDataConstant() {
    }

    //---------------------------------------------------------------------------
    // themeMap返回结果中的父节点的字段名称
    //--------------------------------------------------------------------------
    /**
     * 节点名；执行规则中action执行规则
     */
    public static final String DATA_ACTIONS = "actions";

    /**
     * 节点名；执行规则中action参数\返回值结构定义与元数据
     */
    public static final String DATA_ACTION_METADATAS = "actionMetadatas";
    public static final String STANDARD_PARAMETER_MAPPING = "standardParameterMapping";

    //---------------------------------------------------------------------------
    // themeMap返回结果中的action关联的字段名
    //--------------------------------------------------------------------------
    /**
     * 执行引擎的执行目标
     */
    public static final String ACTION_ACTION_ID = "actionId";
    /**
     * 执行当前action的类型，task\esp\formula\...
     */
    public static final String ACTION_TYPE = "type";
    public static final String ACTION_API_META = "apiMeta";
    /**
     * 描述action是否需要循环执行的标志字段
     */
    public static final String ACTION_FOREACH = "forEach";
    /**
     * 参数类型为MINI_TRANS时，描述如何对source处理产生新的source
     */
    public static final String ACTION_MICRO_TRANS = "microTrans";
    /**
     * 用于灵活拼接服务调用地址的(restful部分)，数据来自themeMap的定义
     */
    public static final String ACTION_URL = "url";
    /**
     * restful风格调用的调用方式 POST\GET\...
     */
    public static final String ACTION_METHOD = "method";
    /**
     * 对返回结果中只取一条记录时，获取方式（随机获取）
     */
    public static final String ACTION_ALLOCATE_TYPE = "allocateType";
    /**
     * 对返回结果中只取一条记录时，随机获取，对应属性项"allocateType"
     */
    public static final String ACTION_ALLOCATETYPE = "RANDOM";
    //-------------------------------------
    /**
     * Mechanism-Action中用于求取机制变量值时需要传入的机制变量参数名
     */
    public static final String ACTION_MECHANISM_VARIABLE_NAME = "variableName";
    //-------------------------------------
    /**
     * Mechanism-Action中用于求取机制变量值时需要传入的机制变量级别
     */
    public static final String ACTION_MECHANISM_EOC_LEVEL = "eocLevel";
    //-------------------------------------
    /**
     * Athena-action中描述调用目标是athena的哪个组件
     */
    public static final String ACTION_MODULE = "module";
    //-------------------------------------
    /**
     * Formula-Action中描述执行引擎需要运行的表达式
     */
    public static final String ACTION_EXPRESSION = "expression";
    /**
     * Formula-Action中用于描述表达式执行结果持有的变量名
     */
    public static final String ACTION_TARGET = "target";
    //-------------------------------------
    /**
     * ESP-action中当前调用的企业应用的产品名称
     */
    public static final String ACTION_VARIABLE_PRODUCT_NAME = "productName";
    /**
     * ESP-action中用于明确esp调用的服务池中的服务名称（API名称）
     */
    public static final String ACTION_SERVICE_NAME = "serviceName";
    //-------------------------------------
    /**
     * Task-action中用于发起流程的流程号
     */
    public static final String ACTION_PROCESS_ID = "processId";
    /**
     * Task-action中用于发起流程时任务号
     */
    public static final String ACTION_TASK_ID = "taskId";
    /**
     * Task-action中执行流程引擎时传入的标题描述
     */
    public static final String ACTION_SUBJECT = "subject";
    /**
     * Task-action中requesterId
     */
    public static final String ACTION_REQUESTERID = "requesterId";
    /**
     * Task-action中locale
     */
    public static final String ACTION_LOCALE = "locale";

    /**
     * Task-action中的async
     */
    public static final String ACTION_ASYNC = "async";
    //-------------------------------------
    /**
     * Trans-action的数据转换规则id
     */
    public static final String ACTION_TRANS_RULE_ID = "ruleId";

    /**
     * dataEvent-action的dataEventId
     */
    public static final String ACTION_DATAEVENT_ID = "dataEventId";
    public static final String ACTION_FIX_SETTING = "fixSetting";

    //---------------------------------------------------------------------------
    // actions中定义的字段名
    //--------------------------------------------------------------------------

    public static final String ACTIONS_PARAMS = "params";

    public static final String ACTIONS_PARAMS_TYPE = "type";

    public static final String ACTIONS_PARAMS_VALUE = "value";

    public static final String ACTIONS_PARAMS_EXCEPT = "except";

    public static final String ACTIONS_PARAMS_NAME = "name";

    public static final String ACTIONS_PARAMS_SOURCE = "source";

    public static final String ACTIONS_PARAMS_CASE_INPUT = "caseInput";

    public static final String ACTIONS_PARAMS_CASE_BRANCHES = "caseBranches";

    public static final String ACTIONS_PARAMS_CASE_BRANCHES_WHEN = "when";

    public static final String ACTIONS_PARAMS_CASE_BRANCHES_THEN = "then";


    //---------------------------------------------------------------------------
    // metadata中定义的字段名
    //--------------------------------------------------------------------------

    public static final String METADATAS_ACTION_REQUEST = "request";

    public static final String METADATAS_ACTION_REQUEST_PARAMETERS = "parameters";

    public static final String METADATAS_ACTION_QUERY_SCHEMA = "querySchema";
    public static final String METADATAS_ACTION_AGGREGATION = "aggregation";
    public static final String METADATAS_DYNAMIC_ACTION_QUERY_SCHEMA = "dynamicQuerySchema";

    public static final String METADATAS_ACTION_RESPONSE = "response";

    public static final String METADATAS_ACTION_RESPONSE_DATA = "data";

    public static final String METADATAS_PARAM_DATA_NAME = "data_name";

    public static final String METADATAS_PARAM_DATA_TYPE = "data_type";

    public static final String METADATAS_PARAM_REQUIRED = "required";

    public static final String METADATAS_PARAM_IS_DATAKEY = "is_datakey";

    public static final String METADATAS_PARAM_IS_ARRAY = "is_array";

    public static final String METADATAS_PARAM_FIELD = "field";
    public static final String METADATAS_PARAM_FIELDS = "fields";

    public static final String BMD_METADATAS_COLUMN_NAME = "columnName";
    public static final String BMD_METADATAS_COLUMN_COMMENT = "columnComment";
    public static final String ACTION_MODE = "actionMode";


}
