package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.TransAction;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.component.param.ParamBase;
import com.digiwin.athena.executionengine.component.param.ParamFactory;
import com.digiwin.athena.executionengine.service.facade.analyzer.AbstractAnalyzerBase;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.json.JsonObjectBuilder;

/**
 * @description: 元数据中的actions分析
 * @author: renwm
 * @date: 2020/6/15 17:41
 */
@Service("engineMetaActionAnalyzer")
public class MetaActionAnalyzer extends AbstractAnalyzerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaActionAnalyzer.class);

    /**
     * 循环Actions 解析
     *
     * @param executionRule
     */
    @Override
    protected void analysisHandler(JSONObject executionRule) {
        if (MapUtils.isEmpty(executionRule)) {
            return;
        }
        JSONArray actions = executionRule.getJSONArray(MetaDataConstant.DATA_ACTIONS);

        // 解析actions的结构，如果没有对象 就结束解析
        if (CollectionUtils.isEmpty(actions)) {
            return;
        }
        //循环actions中的结构，解析actions中的action结构
        for (int i = 0; i < actions.size(); i++) {
            JSONObject actionJson = actions.getJSONObject(i);
            String actionId = actionJson.getString(MetaDataConstant.ACTION_ACTION_ID);
            ActionParam actionParam = getLocalContext().getActionParam(actionId);
            if (null == actionParam) {
                continue;
            }
            analysisParam(actionParam, actionJson);
        }
    }


    /**
     * 初始化action中的param参数
     *
     * @param actionParam
     * @param actionJson
     */
    private void analysisParam(ActionParam actionParam, JSONObject actionJson) {
        actionParam.setActionJson(actionJson);
        actionParam.setForeach(actionJson.getBooleanValue(MetaDataConstant.ACTION_FOREACH));

        JSONArray paramArray = actionJson.getJSONArray(MetaDataConstant.ACTIONS_PARAMS);

        if (CollectionUtils.isEmpty(paramArray)) {
            return;
        }

        for (int i = 0; i < paramArray.size(); i++) {
            JSONObject item = paramArray.getJSONObject(i);
            ParamBase paramBase = ParamFactory.createParam(item);
            if (null == paramBase) {
                continue;
            }
            actionParam.getParams().add(paramBase);
        }
    }


}
