package com.digiwin.athena.executionengine.component.action;

import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/8/14
 */
public interface IActionExecutionProcessor {

    /**
     * 前置处理 action入参处理
     *
     * @param request
     * @param actionParam
     * @return
     */
    default List<Map<String, Object>> postProcessBeforeExecution(List<Map<String, Object>> request, ActionParam actionParam) {
        return request;
    }

    ;

    /**
     * 后置处理 action出参处理
     *
     * @param response
     * @param actionParam
     * @return
     */
    default Object postProcessAfterExecution(Object response, ActionParam actionParam) {
        return response;
    }

    ;


    /**
     * 动态计算
     *
     * @param response
     * @param actionParam
     * @return
     */
    default Object dynamicCompute(ExecuteContext context, Object response, ActionParam actionParam) {
        return response;
    }

    ;
}
