package com.digiwin.athena.executionengine.model;

import java.io.Serializable;
import java.util.List;

/**
 * 补齐数据定义
 *
 * @author wuyang
 */
public class IncrementalDefinition implements Serializable {
    private static final long serialVersionUID = -6155597091148098719L;

    /**
     * 追加方式 keep（保持排序）,append(简单追加)--默认为append
     */
    private String patchWay = "keep";
    /**
     * 确定属于同一个区间的条件字段，不填时自行计算相同取值列
     */
    private List<String> criteria;
    /**
     * 同模型中心的时间格式定义，先支持年月日粒度
     */
    private String granularity;
    private String action;
    /**
     * 依据这个字段确定递增范围，不填时默认同"increase"所述字段
     */
    private String interval;
    /**
     * 查漏补缺的字段，对其查漏补漏
     */
    private String increase;
    /**
     * 缺失字段
     */
    private String missingField;

    public String getMissingField() {
        return missingField;
    }

    public void setMissingField(String missingField) {
        this.missingField = missingField;
    }

    public IncrementalDefinition() {
    }

    public IncrementalDefinition(String patchWay, List<String> criteria, String granularity, String action, String interval, String increase) {
        this.patchWay = patchWay;
        this.criteria = criteria;
        this.granularity = granularity;
        this.action = action;
        this.interval = interval;
        this.increase = increase;
    }

    public String getPatchWay() {
        return patchWay;
    }

    public void setPatchWay(String patchWay) {
        this.patchWay = patchWay;
    }

    public List<String> getCriteria() {
        return criteria;
    }

    public void setCriteria(List<String> criteria) {
        this.criteria = criteria;
    }

    public String getGranularity() {
        return granularity;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getInterval() {
        return interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public String getIncrease() {
        return increase;
    }

    public void setIncrease(String increase) {
        this.increase = increase;
    }
}
