package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.executionengine.constant.TransConstant;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.input.SolutinStep.*;
import com.digiwin.athena.executionengine.service.facade.analyzer.ISolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.convert.trans.ITransDefinitionConvertor;
import com.digiwin.athena.executionengine.service.facade.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.ContextUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.athena.executionengine.constant.TransConstant.CALCULATE_METHOD;

/**
 * 查询步骤，同时会进行groupBy操作，还会判断是否需要执行distinct操作
 */
@Service("selectStep")
public class SelectSolutionStepAnalyzer implements ISolutionStepAnalyzer {

    private static final Logger LOGGER = LoggerFactory.getLogger(SelectSolutionStepAnalyzer.class);

    private ITransDefinitionConvertor transDefinitionConvertor;

    @Autowired
    public void setITransDefinitionConvertor(ITransDefinitionConvertor transDefinitionConvertor) {
        this.transDefinitionConvertor = transDefinitionConvertor;
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, ISolutionStepAnalyzer nextStep, SolutionStepContext context) {

    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        String dataKey = stepIndex + "-" + solutionStep.getAlias();
        Object selectData = SolutionStepExecutionFacade.getTransDataMap() != null
                && SolutionStepExecutionFacade.getTransDataMap().containsKey(dataKey)
                ? SolutionStepExecutionFacade.getTransDataMap().get(dataKey) : null;
        LOGGER.info("selectStep开始执行selectData==null:{}", selectData == null ? "true" : "false");
        if (selectData != null) {
            List<Select> selectList = solutionStep.getSelect();
            //需要单独计算的列
            List<Select> computeSelectList = new ArrayList<>();
            ////判断是否有RowNumber这类型的特殊计算
            List<Select> specialComputeSelectList = new ArrayList<>();
            selectList.forEach(select -> {
                //取出计算的列
                if ("calculate".equals(select.getDataObject().getContentType())) {
                    String computeName = select.getDataObject().getContent();
                    JSONArray computeArray = solutionStep.getComputeList().getJSONArray(computeName);
                    for (int j = 0; j < computeArray.size(); j++) {
                        String computeType = computeArray.getJSONObject(j).getString("calFunction");
                        //RowNumber判断
                        if ("RowNumber".equalsIgnoreCase(computeType) && !specialComputeSelectList.contains(select)) {
                            specialComputeSelectList.add(select);
                        }
                        //判断是否有查询字段需要计算，不需要groupBy的计算，如a-b a+b 这些
                        List<String> methodList = Arrays.stream(CALCULATE_METHOD.split(",")).collect(Collectors.toList());
                        if (methodList.contains(computeType.toUpperCase()) && !computeSelectList.contains(select)) {
                            computeSelectList.add(select);
                        }
                    }
                }
            });
            //存在RowNumber这种特殊计算
            if (!specialComputeSelectList.isEmpty()) {
                //先计算RowNumber
                for (Select select : specialComputeSelectList) {
                    //用于分组排序的分组字段
                    JSONArray rowNumberGroupFields = new JSONArray();
                    String computeName = select.getDataObject().getContent();
                    JSONArray computeArray = solutionStep.getComputeList().getJSONArray(computeName);
                    JSONArray oderByJson = computeArray.getJSONObject(0).getJSONObject("overParams").getJSONArray("orderBy");
                    JSONArray partitionArray = computeArray.getJSONObject(0).getJSONObject("overParams").getJSONArray("partition");
                    if (partitionArray != null) {
                        for (int j = 0; j < partitionArray.size(); j++) {
                            //取出用于partition的所有字段
                            JSONObject partition = partitionArray.getJSONObject(j);
                            String content = partition.getString("content");
                            if ("field".equalsIgnoreCase(partition.getString("contentType"))) {
                                //如果是字段
                                rowNumberGroupFields.add(content);
                                DataObject dataObject = JSON.parseObject(partition.toJSONString(), DataObject.class);
                                Sort sort = new Sort();
                                sort.setDataObject(dataObject);
                                sort.setOrder("asc");
                                oderByJson.add(JSONObject.parseObject(JSONObject.toJSONString(sort)));
                            } else {
                                //计算列
                                Object tempData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                                JSONArray dataArray = JSONArray.parseArray(JSON.toJSONString(tempData, SerializerFeature.WriteMapNullValue));
                                if (!dataArray.isEmpty()) {
                                    JSONObject data = dataArray.getJSONObject(0);
                                    Set<String> fieldKeys = data.keySet();
                                    String newField = doRowNumberCalculate(content, solutionStep.getComputeList(), fieldKeys, selectData, context, dataKey);
                                    rowNumberGroupFields.add(newField);
                                    DataObject dataObject = JSON.parseObject(partition.toJSONString(), DataObject.class);
                                    dataObject.setContent(newField);
                                    dataObject.setContentType("field");
                                    Sort sort = new Sort();
                                    sort.setDataObject(dataObject);
                                    sort.setOrder("asc");
                                    oderByJson.add(JSONObject.parseObject(JSONObject.toJSONString(sort)));
                                }
                            }
                        }
                    }
                    JSONObject sortJSON = new JSONObject();
                    sortJSON.put("fields", rowNumberGroupFields);
                    sortJSON.put("sort", oderByJson);
                    sortJSON.put("mode", TransConstant.GROUP_MODE_CUSTOM);
                    sortJSON.put("sortName", computeArray.getJSONObject(0).getString("newField"));
                    JSONObject criteriaDefinition = new JSONObject();
                    criteriaDefinition.put("technique", "sorts");
                    criteriaDefinition.put("schema", sortJSON);
                    JSONObject jsonObject = transDefinitionConvertor.convert(criteriaDefinition);
                    Map<String, Object> dataMap = new HashMap<>();
                    dataMap.put(dataKey, SolutionStepExecutionFacade.getTransDataMap().get(dataKey));
                    TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
                    TransEngine transEngine = ContextUtils.getBean(TransEngine.class);
                    Object resultData = transEngine.runEngine(transDataManger);
                    SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
                }
            }
            if (!CollectionUtils.isNotEmpty(solutionStep.getGroupby())) {
                //如果没有groupBy
                //TODO:1012不考虑数据集的情况
                JSONArray newDataArray = new JSONArray();
                if (!computeSelectList.isEmpty()) {
                    for (Select select : computeSelectList) {
                        selectData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                        doSelectCalculate(select, solutionStep.getComputeList(), selectData, context, dataKey);
                    }
                }
                //前面有计算，重新取数据
                JSONArray dataArray = JSONArray.parseArray(JSON.toJSONString(SolutionStepExecutionFacade.getTransDataMap().get(dataKey), SerializerFeature.WriteMapNullValue));
                for (int i = 0; i < dataArray.size(); i++) {
                    JSONObject newJsonObject = new JSONObject();
                    JSONObject data = dataArray.getJSONObject(i);
                    Set<String> keys = data.keySet();
                    for (String key : keys) {
                        //判断查询的字段是否在结果集中
                        if (selectList.stream().anyMatch(select -> key.equals(select.getDataObject().getContent()))) {
                            //在就放进去，用于踢出不存在字段
                            newJsonObject.put(key, data.get(key));
                        }
                    }
                    selectList.forEach(select -> {
                        if ("const".equals(select.getDataObject().getContentType())) {
                            //为常量
                            DataObject dataObject = select.getDataObject();
                            newJsonObject.put(dataObject.getAlias(), dataObject.getContent());
                        }
                    });
                    if (!newJsonObject.isEmpty()) {
                        newDataArray.add(newJsonObject);
                    }
                }
                SolutionStepExecutionFacade.getTransDataMap().put(dataKey, newDataArray);
                if (newDataArray.isEmpty() && !dataArray.isEmpty()) {
                    //有数据，但是没有拿到，查询字段为计算列
                    List<String> selectFunctionName = selectList.stream().filter(select ->
                            "calculate".equals(select.getDataObject().getContentType())
                    ).map(select -> select.getDataObject().getContent()).collect(Collectors.toList());
                    JSONObject computeList = solutionStep.getComputeList();
                    JSONArray functionFields = createFunctionFields(selectFunctionName, computeList);
                    Map<String, Object> dataMap = new HashMap<>();
                    dataMap.put(dataKey, selectData);
                    Object result = doGroupTrans(new JSONArray(), functionFields, dataMap, context);
                    SolutionStepExecutionFacade.getTransDataMap().put(dataKey, result);
                }
            } else {
                JSONArray groupFields = new JSONArray();
                Object tempData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                JSONArray dataArray = JSONArray.parseArray(JSON.toJSONString(tempData, SerializerFeature.WriteMapNullValue));
                if (!dataArray.isEmpty()) {
                    JSONObject data = dataArray.getJSONObject(0);
                    Set<String> fieldKeys = data.keySet();
                    for (GroupBy groupBy : solutionStep.getGroupby()) {
                        if ("field".equals(groupBy.getContentType())) {
                            groupFields.add(groupBy.getContent());
                        } else if ("calculate".equals(groupBy.getContentType())) {
                            //计算字段
                            tempData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                            GroupBy newGroupBy = doGroupCalculate(groupBy, solutionStep.getComputeList(), fieldKeys, tempData, context, dataKey);
                            if (!groupFields.contains(newGroupBy.getContent())) {
                                groupFields.add(newGroupBy.getContent());
                            }
                        }
                    }
                    Map<String, Object> dataMap = new HashMap<>();
                    dataMap.put(dataKey, SolutionStepExecutionFacade.getTransDataMap().get(dataKey));
                    JSONObject computeList = solutionStep.getComputeList();
                    Set<String> computeKeys = computeList.keySet();
                    JSONArray functionFields = createFunctionFields(new ArrayList<>(computeKeys), computeList);
                    Object resultData = doGroupTrans(groupFields, functionFields, dataMap, context);
                    if (solutionStep.getHaving() != null && resultData != null) {
                        //存在having,转为filter操作
                        Having having = solutionStep.getHaving();
                        List<FilterHavingChildren> newChildren = dealHavingChildren(having.getChildren(), computeList, context, stepIndex, solutionStep.getDatasetObject().getAlias());
                        JSONObject criteriaDefinition = new JSONObject();
                        criteriaDefinition.put("technique", "filter");
                        Filter filter = new Filter();
                        filter.setLogic(having.getLogic());
                        if (CollectionUtils.isNotEmpty(newChildren)) {
                            filter.setChildren(newChildren);
                            criteriaDefinition.put("schema", JSONObject.parseObject(JSONObject.toJSONString(filter)));
                            JSONObject jsonObject = transDefinitionConvertor.convert(criteriaDefinition);
                            LOGGER.info("filterStep执行trans入参:{}", JSONObject.toJSONString(jsonObject));
                            dataMap = new HashMap<>();
                            dataMap.put(dataKey, resultData);
                            TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
                            TransEngine transEngine = ContextUtils.getBean(TransEngine.class);
                            resultData = transEngine.runEngine(transDataManger);
                        }
                    }
                    SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
                }
            }
            List<String> columnList = new ArrayList<>();
            for (Select select : selectList) {
                if (select.getDataObject() != null) {
                    String contentType = select.getDataObject().getContentType();
                    switch (contentType) {
                        case "const":
                            columnList.add(select.getDataObject().getAlias());
                            break;
                        case "calculate":
                            String computeName = select.getDataObject().getContent();
                            JSONArray computeArray = solutionStep.getComputeList().getJSONArray(computeName);
                            String newField = computeArray.getJSONObject(computeArray.size() - 1).getString("newField");
                            columnList.add(newField);
                            break;
                        default:
                            columnList.add(select.getDataObject().getContent());
                    }
                }
            }
            if (!columnList.isEmpty()) {
                Object data = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                JSONArray dataArray = JSONArray.parseArray(JSON.toJSONString(data, SerializerFeature.WriteMapNullValue));
                JSONArray newDataArray = new JSONArray();
                for (int i = 0; i < dataArray.size(); i++) {
                    JSONObject newJsonObject = new JSONObject();
                    JSONObject rowData = dataArray.getJSONObject(i);
                    Set<String> keys = rowData.keySet();
                    for (String key : keys) {
                        if (columnList.stream().anyMatch(key::equals)) {
                            newJsonObject.put(key, rowData.get(key));
                        }
                    }
                    if (!newJsonObject.isEmpty()) {
                        newDataArray.add(newJsonObject);
                    }
                }
                SolutionStepExecutionFacade.getTransDataMap().put(dataKey, newDataArray);
            }
            if (CollectionUtils.isNotEmpty(solutionStep.getSort())) {
                ISolutionStepAnalyzer sortStep = ContextUtils.getBean("sortStep");
                sortStep.executeStep(solutionStep, stepIndex, context);
            } else if (solutionStep.getLimit() != null) {
                ISolutionStepAnalyzer limitStep = ContextUtils.getBean("limitStep");
                limitStep.executeStep(solutionStep, stepIndex, context);
            } else if (CollectionUtils.isNotEmpty(solutionStep.getUnion())) {
                ISolutionStepAnalyzer unionStep = ContextUtils.getBean("unionStep");
                unionStep.executeStep(solutionStep, stepIndex, context);
            } else {
                SolutionStepExecutionFacade.getTransDataMap().put(solutionStep.getAlias(), SolutionStepExecutionFacade.getTransDataMap().get(dataKey));
                SolutionStepExecutionFacade.getTransDataMap().remove(dataKey);
            }
        }
    }

    /**
     * 执行Trans
     *
     * @param groupFields
     * @param functionFields
     * @param dataMap
     * @param context
     * @return 返回结果数据
     */
    public Object doGroupTrans(JSONArray groupFields, JSONArray functionFields, Map<String, Object> dataMap, SolutionStepContext context) {
        JSONObject schema = new JSONObject();
        schema.put("groupFields", groupFields);
        schema.put("functionFields", functionFields);

        JSONArray distinctFields = new JSONArray();
        for (int i = 0; i < functionFields.size(); i++) {
            String methodName = functionFields.getJSONObject(i).getString("method");
            if (TransConstant.DISTINCT_FUNCTION.contains(methodName)) {
                distinctFields.add(functionFields.getJSONObject(i).getString("newFields"));
            }
        }
        distinctFields.addAll(groupFields);
        schema.put("distinctFields", distinctFields);

        JSONObject criteriaDefinition = new JSONObject();
        criteriaDefinition.put("technique", "group");
        criteriaDefinition.put("schema", schema);


        JSONObject jsonObject = transDefinitionConvertor.convert(criteriaDefinition);
        LOGGER.info("selectStep执行trans入参:{}", JSONObject.toJSONString(jsonObject));
        TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = ContextUtils.getBean(TransEngine.class);
        Object result = transEngine.runEngine(transDataManger);


        if (!distinctFields.isEmpty()) {
            distinctFields.addAll(groupFields);
            result = doDistinctTrans(distinctFields, result, context);
        }
        return result;
    }

    /**
     * 执行去重操作
     *
     * @param distinctFields
     * @param data
     * @param context
     * @return
     */
    public Object doDistinctTrans(JSONArray distinctFields, Object data, SolutionStepContext context) {
        JSONObject schema = new JSONObject();
        schema.put("distinctFields", distinctFields);
        JSONObject criteriaDefinition = new JSONObject();
        criteriaDefinition.put("technique", "distinct");
        criteriaDefinition.put("schema", schema);
        JSONObject jsonObject = transDefinitionConvertor.convert(criteriaDefinition);
        LOGGER.info("distinctStep执行trans入参:{}", JSONObject.toJSONString(jsonObject));
        TransDataManger transDataManger = new TransDataManger(jsonObject, data, context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = ContextUtils.getBean(TransEngine.class);
        return transEngine.runEngine(transDataManger);
    }

    /**
     * 创建trans的functionFields
     *
     * @param computeKeys
     * @param computeList
     * @return
     */
    public JSONArray createFunctionFields(List<String> computeKeys, JSONObject computeList) {
        JSONArray functionFields = new JSONArray();
        for (String computeKey : computeKeys) {
            JSONArray computeArray = computeList.getJSONArray(computeKey);
            List<String> methodList = Arrays.stream(CALCULATE_METHOD.split(",")).collect(Collectors.toList());
            if (computeArray.stream().anyMatch(compute -> {
                String functionName = ((JSONObject) compute).getString("calFunction");
                return methodList.contains(functionName.toUpperCase()) || functionName.equalsIgnoreCase("RowNumber");
            })) {
                continue;
            }
            for (int i = 0; i < computeArray.size(); i++) {
                JSONObject compute = computeArray.getJSONObject(i);
                JSONObject function = new JSONObject();
                function.put("method", compute.getString("calFunction").toLowerCase());
                JSONArray fields = new JSONArray();

                JSONArray parameters = compute.getJSONArray("params");
                for (int j = 0; j < parameters.size(); j++) {
                    JSONObject parameter = parameters.getJSONObject(j);
                    fields.add(parameter.getString("content"));
                }
                function.put("fields", fields);
                function.put("valueType", compute.getString("valueType"));
                function.put("newFields", compute.getString("newField"));
                functionFields.add(function);
            }
        }
        return functionFields;
    }

    /**
     * 对计算列进行计算操作，返回执行完计算后的baseObject,同时更新结果数据
     *
     * @param groupBy
     * @param computeList
     * @param fieldKeys
     * @param data
     * @param context
     * @param dataKey
     * @return
     */
    public GroupBy doGroupCalculate(GroupBy groupBy, JSONObject computeList, Set<String> fieldKeys, Object data, SolutionStepContext context, String dataKey) {
        GroupBy newObject = new GroupBy();
        if (!"calculate".equals(groupBy.getContentType())) {
            return groupBy;
        }
        String computeName = groupBy.getContent();
        JSONArray newComputeJsonArray = new JSONArray();
        JSONArray computeJsonArray = computeList.getJSONArray(computeName);
        for (int i = 0; i < computeJsonArray.size(); i++) {
            //判断运算的字段是否还在
            JSONObject compute = computeJsonArray.getJSONObject(i);
            String calFunction = compute.getString("calFunction");
            List<String> methodList = Arrays.stream(CALCULATE_METHOD.split(",")).collect(Collectors.toList());
            if (!methodList.contains(calFunction.toUpperCase())) {
                LOGGER.info("selectStep执行doCalculate.trans中计算暂不支持:{}", compute.getString("calFunction"));
                continue;
            }
            JSONArray parameters = compute.getJSONArray("params");
            boolean flag = false;
            for (int j = 0; j < parameters.size(); j++) {
                JSONObject parameter = parameters.getJSONObject(j);
                if (!fieldKeys.contains(parameter.getString("content")) && "field".equals(parameter.getString("contentType"))) {
                    //没有这个字段
                    flag = true;
                    LOGGER.info("selectStep执行doCalculate.trans中计算列不存在于数据集中:{}", parameter.toJSONString());
                }
            }
            if (!flag) {
                newComputeJsonArray.add(compute);
            }
        }
        Object calculateResult = doCalculate(newComputeJsonArray, data, context);
        if (calculateResult == null) {
            LOGGER.info("selectStep.doGroupCalculate执行doCalculate.trans出参为null");
            return groupBy;
        }
        JSONObject lastCalculateFunction = computeJsonArray.getJSONObject(computeJsonArray.size() - 1);
        newObject.setContent(lastCalculateFunction.getString("newField"));
        newObject.setSource(groupBy.getSource());
        newObject.setContentType("field");
        newObject.setDataType(lastCalculateFunction.getString("valueType"));
        newObject.setAlias(groupBy.getAlias());
        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, calculateResult);
        return newObject;
    }

    /**
     * 对计算列进行计算操作，同时更新结果数据
     *
     * @param select
     * @param computeList
     * @param data
     * @param context
     * @param dataKey
     * @return
     */
    public void doSelectCalculate(Select select, JSONObject computeList, Object data, SolutionStepContext context, String dataKey) {
        if (select.getDataObject() == null) {
            return;
        }
        if (!"calculate".equals(select.getDataObject().getContentType())) {
            return;
        }
        String computeName = select.getDataObject().getContent();
        JSONArray computeJsonArray = computeList.getJSONArray(computeName);
        for (int j = 0; j < computeJsonArray.size(); j++) {
            String computeType = computeJsonArray.getJSONObject(j).getString("calFunction");
            List<String> methodList = Arrays.stream(CALCULATE_METHOD.split(",")).collect(Collectors.toList());
            if (!methodList.contains(computeType.toUpperCase())) {
                return;
            }
        }

        //因为select中的计算的字段肯定存在于数据中
        Object calculateResult = doCalculate(computeJsonArray, data, context);
        if (calculateResult == null) {
            LOGGER.info("selectStep.doSelectCalculate执行doCalculate.trans出参为null");
            return;
        }
        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, calculateResult);
    }

    /**
     * 执行计算,单个calculate数组会有多个计算，会顺序计算
     *
     * @param ruleJson 规则json
     * @param data     计算数据
     * @param context  context
     * @return 计算结果数据
     */
    private Object doCalculate(JSONArray ruleJson, Object data, SolutionStepContext context) {
        JSONObject schema = new JSONObject();
        schema.put("rule", ruleJson);
        JSONObject criteriaDefinition = new JSONObject();
        criteriaDefinition.put("technique", "calculate");
        criteriaDefinition.put("schema", schema);
        JSONObject jsonObject = transDefinitionConvertor.convert(criteriaDefinition);
        LOGGER.info("selectStep执行doCalculate.trans入参:{}", JSONObject.toJSONString(jsonObject));
        TransDataManger transDataManger = new TransDataManger(jsonObject, data, context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = ContextUtils.getBean(TransEngine.class);
        return transEngine.runEngine(transDataManger);
    }

    /**
     * 处理having过滤的children
     *
     * @param children
     * @param computeList
     * @param context
     * @param stepIndex
     * @param alias
     * @return
     */
    private List<FilterHavingChildren> dealHavingChildren(List<FilterHavingChildren> children, JSONObject computeList, SolutionStepContext context, int stepIndex, String alias) {
        List<FilterHavingChildren> newChildren = new ArrayList<>();
        if (CollectionUtils.isEmpty(children)) {
            return newChildren;
        }
        for (FilterHavingChildren filterHavingChildren : children) {
            FilterHavingChildren newChild = new FilterHavingChildren();
            newChild.setOperator(filterHavingChildren.getOperator());
            newChild.setLogic(filterHavingChildren.getLogic());
            //处理左字段
            BaseObject leftObject = createCalculateBaseObject(filterHavingChildren.getLeft(), computeList);
            if (leftObject != null) {
                newChild.setLeft(leftObject);
            }
            //处理右字段
            List<FilterHavingChildrenRight> newRightList = new ArrayList<>();
            List<FilterHavingChildrenRight> rightList = filterHavingChildren.getRight();
            for (FilterHavingChildrenRight filterHavingChildrenRight : rightList) {
                FilterHavingChildrenRight newChildRight = new FilterHavingChildrenRight();
                if (filterHavingChildrenRight.getDataObject() != null) {
                    BaseObject rightObject = createCalculateBaseObject(filterHavingChildrenRight.getDataObject(), computeList);
                    if (rightObject != null) {
                        newChildRight.setDataObject(rightObject);
                    } else {
                        newChildRight = null;
                    }
                } else {
                    //如果是数据集
                    DatasetObject datasetObject = filterHavingChildrenRight.getDatasetObject();
                    Object rightData = null;
                    if ("metric".equals(datasetObject.getDatasetType())) {
                        rightData = SolutionStepExecutionFacade.getMetricData(datasetObject.getAlias());
                    } else if ("step".equals(datasetObject.getDatasetType())) {
                        Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                        if (dataMap.containsKey(datasetObject.getStep())) {
                            rightData = dataMap.get(datasetObject.getStep());
                        }
                    } else if ("subQuery".equals(datasetObject.getDatasetType())) {
                        //调用上一步骤，递归执行
                        DatasetObjectSolutionStepAnalyzer datasetObjectSolutionStepAnalyzer = ContextUtils.getBean("datasetObjectStep");
                        datasetObjectSolutionStepAnalyzer.executeStep(datasetObject.getSubQuery(), stepIndex, context);
                        Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                        String key = stepIndex + "-" + datasetObject.getSubQuery().getAlias();
                        if (dataMap.containsKey(key)) {
                            rightData = dataMap.get(key);
                        }
                    }
                    BaseObject baseObject = new BaseObject();
                    baseObject.setContent(JSONObject.toJSONString(rightData, SerializerFeature.WriteMapNullValue));
                    baseObject.setSource(alias);
                    baseObject.setContent("const");
                    baseObject.setDataType("string");
                    newChildRight.setDataObject(baseObject);
                }
                if (newChildRight != null) {
                    newRightList.add(newChildRight);
                }
            }
            if (CollectionUtils.isNotEmpty(newRightList)) {
                newChild.setRight(newRightList);
            }
            //递归处理children
            List<FilterHavingChildren> childChildren = dealHavingChildren(filterHavingChildren.getChildren(), computeList, context, stepIndex, alias);
            if (CollectionUtils.isNotEmpty(childChildren)) {
                newChild.setChildren(childChildren);
            }
            if (newChild.getLeft() != null && CollectionUtils.isNotEmpty(newChild.getRight())) {
                newChildren.add(newChild);
            }
        }
        return newChildren;
    }

    /**
     * 生成对应的BaseObject--having的过滤字段只会是计算字段
     * 非计算字段直接filter就过滤了
     *
     * @param baseObject  原始的
     * @param computeList 计算信息
     * @return newBaseObject
     */
    private BaseObject createCalculateBaseObject(BaseObject baseObject, JSONObject computeList) {
        BaseObject newBaseObject = new BaseObject();
        if ("calculate".equals(baseObject.getContentType())) {
            newBaseObject = new BaseObject();
            //取到计算方法
            JSONArray computeArray = computeList.getJSONArray(baseObject.getContent());
            //取到最后一步计算，用来取计算后的新字段名称
            JSONObject lastComputeJson = computeArray.getJSONObject(computeArray.size() - 1);
            String newFieldName = lastComputeJson.getString("newField");
            newBaseObject.setContent(newFieldName);
            newBaseObject.setContentType("field");
            newBaseObject.setSource(baseObject.getSource());
            newBaseObject.setDataType(baseObject.getDataType());
            return newBaseObject;
        }
        BeanUtils.copyProperties(baseObject, newBaseObject);
        return newBaseObject;
    }

    /**
     * 对计算列进行计算操作,同时更新结果数据，返回计算后的新字段名称
     *
     * @param computeName 计算名称
     * @param computeList
     * @param fieldKeys
     * @param data
     * @param context
     * @param dataKey
     * @return 计算得到的新字段名称
     */
    public String doRowNumberCalculate(String computeName, JSONObject computeList, Set<String> fieldKeys, Object data, SolutionStepContext context, String dataKey) {
        String newFieldName = null;
        if (!computeList.containsKey(computeName)) {
            return null;
        }
        JSONArray newComputeJsonArray = new JSONArray();
        JSONArray computeJsonArray = computeList.getJSONArray(computeName);
        for (int i = 0; i < computeJsonArray.size(); i++) {
            //判断运算的字段是否还在
            JSONObject compute = computeJsonArray.getJSONObject(i);
            String calFunction = compute.getString("calFunction");
            List<String> methodList = Arrays.stream(CALCULATE_METHOD.split(",")).collect(Collectors.toList());
            if (!methodList.contains(calFunction.toUpperCase())) {
                LOGGER.info("selectStep执行doRowNumberCalculate.trans中计算暂不支持:{}", compute.getString("calFunction"));
                continue;
            }
            //多个会以最后一个计算的newField作为最终的新字段
            newFieldName = compute.getString("newField");
            JSONArray parameters = compute.getJSONArray("params");
            boolean flag = false;
            for (int j = 0; j < parameters.size(); j++) {
                JSONObject parameter = parameters.getJSONObject(j);
                if (!fieldKeys.contains(parameter.getString("content")) && "field".equals(parameter.getString("contentType"))) {
                    //没有这个字段
                    flag = true;
                    LOGGER.info("selectStep执行doRowNumberCalculate.trans中计算列不存在于数据集中:{}", parameter.toJSONString());
                }
            }
            if (!flag) {
                newComputeJsonArray.add(compute);
            }
        }
        Object calculateResult = doCalculate(newComputeJsonArray, data, context);
        if (calculateResult == null) {
            LOGGER.info("selectStep.doRowNumberCalculate执行doCalculate.trans出参为null");
            return null;
        }
        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, calculateResult);
        return newFieldName;
    }
}
