package com.digiwin.athena.executionengine.service.facade.reporter;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.model.reporter.ErrorLogReportDto;
import com.digiwin.athena.executionengine.model.reporter.ReporterDto;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/8/1
 */
@Service("engineErrorLogReporter")
public class ErrorLogReporter implements IReporter {

    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorLogReporter.class);

    @Override
    public void report(ReporterDto reporterDto) {
        ErrorLogReportDto errorLogReportDto = (ErrorLogReportDto) reporterDto;
        try {
            Map<String, String> header = new HashMap<>();
            header.put("Content-Type", "application/json;charset=UTF-8");
            header.put(FieldNameConstant.USER_TOKEN, errorLogReportDto.getToken());
            header.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, errorLogReportDto.getRouterKey());
            HttpClientUtils.doPost(ModuleProperty.AGILE_DATA_ECHO_URL, header, JSON.toJSONString(errorLogReportDto));
        } catch (Exception e) {
            LOGGER.error("errorlog report error", e);
        }

    }
}
