/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.Metric;
import com.digiwin.athena.executionengine.model.input.SolutinStep.BaseObject;
import com.digiwin.athena.executionengine.model.input.SolutinStep.DataObject;
import com.digiwin.athena.executionengine.model.input.SolutinStep.DatasetObject;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Filter;
import com.digiwin.athena.executionengine.model.input.SolutinStep.FilterHavingChildren;
import com.digiwin.athena.executionengine.model.input.SolutinStep.FilterHavingChildrenRight;
import com.digiwin.athena.executionengine.model.input.SolutinStep.GroupBy;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Having;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Join;
import com.digiwin.athena.executionengine.model.input.SolutinStep.On;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Select;
import com.digiwin.athena.executionengine.model.input.SolutinStep.SolutionStep;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Union;
import com.digiwin.athena.executionengine.model.solutionStep.SolutionStepMetric;
import com.digiwin.athena.executionengine.service.facade.analyzer.IDataValueExtractor;
import com.digiwin.athena.executionengine.service.facade.analyzer.ISolutionStepMetricAnalyzerFacade;
import com.digiwin.athena.executionengine.service.facade.data.IScraper;
import com.digiwin.athena.executionengine.service.facade.execution.IExecutionFacade;
import com.digiwin.athena.executionengine.service.facade.execution.ISolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.service.facade.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.LogUtils;
import com.digiwin.athena.executionengine.vo.MetricResultVo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SolutionStepMetricAnalyzer
implements ISolutionStepMetricAnalyzerFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionStepMetricAnalyzer.class);
    @Autowired
    private IDataValueExtractor dataValueExtractor;
    private IExecutionFacade executionFacade;
    private ISolutionStepExecutionFacade solutionStepExecutionFacade;

    @Autowired
    public void setExecutionFacade(IExecutionFacade executionFacade) {
        this.executionFacade = executionFacade;
    }

    @Autowired
    public void setSolutionStepExecutionFacade(ISolutionStepExecutionFacade solutionStepExecutionFacade) {
        this.solutionStepExecutionFacade = solutionStepExecutionFacade;
    }

    @Override
    public void analyseMetric(SolutionStep solutionStep, SolutionStepContext context, Integer solutionStepIndex) {
        this.findMetrics(solutionStep, solutionStepIndex, context);
    }

    private void findMetrics(SolutionStep solutionStep, int solutionStepIndex, SolutionStepContext context) {
        List<Union> unionList;
        Having having;
        Filter filter;
        List<Join> joinList;
        LOGGER.info("\u5f00\u59cb\u67e5\u627esolutionStep\u4e2d\u7684Metric:{},stepIndex:{}", (Object)solutionStep.getAlias(), (Object)solutionStepIndex);
        DatasetObject datasetObject = solutionStep.getDatasetObject();
        this.datasetObjectMetricAnalyzer(solutionStep, datasetObject, solutionStepIndex, context);
        List<Select> selectList = solutionStep.getSelect();
        if (selectList != null) {
            LOGGER.info("\u5f00\u59cb\u67e5\u627eselectList\u4e2d\u7684Metric:{},stepIndex:{}", (Object)selectList.size(), (Object)solutionStepIndex);
            for (Select select : selectList) {
                this.datasetObjectMetricAnalyzer(null, select.getDatasetObject(), solutionStepIndex, context);
            }
        }
        if ((joinList = solutionStep.getJoin()) != null) {
            LOGGER.info("\u5f00\u59cb\u67e5\u627ejoinList\u4e2d\u7684Metric:{},stepIndex:{}", (Object)joinList.size(), (Object)solutionStepIndex);
            for (Join join : joinList) {
                this.datasetObjectMetricAnalyzer(null, join.getDatasetObject(), solutionStepIndex, context);
            }
        }
        if ((filter = solutionStep.getFilter()) != null && filter.getChildren() != null) {
            LOGGER.info("\u5f00\u59cb\u67e5\u627efilter\u4e2d\u7684Metric:filter,stepIndex:{}", (Object)solutionStepIndex);
            List<FilterHavingChildren> childrenList = filter.getChildren();
            this.filterHavingMetricAnalyzer(childrenList, solutionStepIndex, context);
        }
        if ((having = solutionStep.getHaving()) != null && having.getChildren() != null) {
            LOGGER.info("\u5f00\u59cb\u67e5\u627ehaving\u4e2d\u7684Metric:having,stepIndex:{}", (Object)solutionStepIndex);
            this.filterHavingMetricAnalyzer(having.getChildren(), solutionStepIndex, context);
        }
        if ((unionList = solutionStep.getUnion()) != null) {
            LOGGER.info("\u5f00\u59cb\u67e5\u627eunionList\u4e2d\u7684Metric:{},stepIndex:{}", (Object)unionList.size(), (Object)solutionStepIndex);
            for (Union union : unionList) {
                SolutionStep unionSolutionStep = union.getSubQuery();
                this.findMetrics(unionSolutionStep, solutionStepIndex, context);
            }
        }
    }

    private void datasetObjectMetricAnalyzer(SolutionStep baseSolutionStep, DatasetObject datasetObject, int solutionStepIndex, SolutionStepContext context) {
        if (datasetObject != null) {
            LOGGER.info("datasetObjectMetricAnalyzer\u5f00\u59cb...");
            String datasetType = datasetObject.getDatasetType();
            if ("metric".equalsIgnoreCase(datasetType) || "metricDataset".equalsIgnoreCase(datasetType) || "dataset".equals(datasetType)) {
                LOGGER.info("datasetObjectMetricAnalyzer\u5206\u6790datasetObject\u4e3aMetric...");
                String alias = datasetObject.getAlias();
                List<SolutionStepMetric> metrics = SolutionStepExecutionFacade.getSolutionStepMetrics();
                if (metrics.stream().noneMatch(item -> item.getAlias().equals(alias))) {
                    LOGGER.info("datasetObjectMetricAnalyzer\u5206\u6790datasetObject\u4e3aMetric\uff0c\u4e14\u6307\u6807\u6ca1\u6709\u91cd\u590d\u51fa\u73b0\uff0c\u5f00\u59cb\u6307\u6807\u53d6\u6570...");
                    SolutionStepMetric metric = new SolutionStepMetric();
                    metric.setMetric(datasetObject.getMetric());
                    metric.setAlias(alias);
                    metric.setCount(metric.getCount() == null || metric.getCount() == 0 ? 1 : metric.getCount() + 1);
                    Filter filter = baseSolutionStep == null ? null : this.createrMetricFilter(baseSolutionStep.getFilter(), alias, solutionStepIndex, context);
                    metric.setFilter(filter);
                    Having having = baseSolutionStep == null ? null : this.createMetricHaving(baseSolutionStep.getHaving(), alias, solutionStepIndex, context);
                    metric.setHaving(having);
                    List<GroupBy> groupByList = baseSolutionStep == null ? null : this.createMetricGroupBy(baseSolutionStep.getGroupby(), baseSolutionStep.getJoin(), baseSolutionStep.getSelect(), alias);
                    metric.setGroupBy(groupByList);
                    metric.setComputeList(baseSolutionStep == null ? null : baseSolutionStep.getComputeList());
                    metric.setSort(baseSolutionStep == null ? null : baseSolutionStep.getSort());
                    metric.setSelect(baseSolutionStep.getSelect());
                    metric.setModelId(context.getModelIdMapping().get(metric.getMetric()));
                    metric.setModelCode(context.getModelCodeMapping().get(metric.getMetric()));
                    if (context.isNeedData()) {
                        this.fetchData(metric, context, datasetType);
                    } else {
                        this.buildMetricExportConditions(metric);
                    }
                    metrics.add(metric);
                }
            } else if ("subquery".equalsIgnoreCase(datasetType)) {
                LOGGER.info("datasetObjectMetricAnalyzer\u5206\u6790datasetObject\u4e3asubquery,\u7ee7\u7eed\u5f80\u4e0b\u67e5\u627e...");
                this.findMetrics(datasetObject.getSubQuery(), solutionStepIndex, context);
            }
        }
    }

    private void buildMetricExportConditions(SolutionStepMetric metric) {
        JSONObject dynamicSchema = new JSONObject();
        dynamicSchema.put("groupBy", CollectionUtils.isEmpty(metric.getGroupBy()) ? null : JSONArray.parseArray((String)JSONArray.toJSONString(metric.getGroupBy())));
        dynamicSchema.put("filter", metric.getFilter() == null || CollectionUtils.isEmpty(metric.getFilter().getChildren()) ? null : JSONObject.parseObject((String)JSONObject.toJSONString((Object)metric.getFilter())));
        dynamicSchema.put("having", metric.getHaving() == null || CollectionUtils.isEmpty(metric.getHaving().getChildren()) ? null : JSONObject.parseObject((String)JSONObject.toJSONString((Object)metric.getHaving())));
        dynamicSchema.put("computeList", metric.getComputeList() == null || metric.getComputeList().isEmpty() ? null : metric.getComputeList());
        dynamicSchema.put("sort", CollectionUtils.isEmpty(metric.getSort()) ? null : JSONArray.parseArray((String)JSONObject.toJSONString(metric.getSort())));
        List<Metric> metricList = SolutionStepExecutionFacade.getExportMetrics();
        if (metricList.stream().noneMatch(m -> m.getAlias().equals(metric.getAlias()))) {
            Metric mObj = new Metric(metric.getMetric(), dynamicSchema, metric.getAlias());
            metricList.add(mObj);
        }
        SolutionStepExecutionFacade.setExportMetrics(metricList);
    }

    private void filterHavingMetricAnalyzer(List<FilterHavingChildren> childrenList, int solutionStepIndex, SolutionStepContext context) {
        for (FilterHavingChildren child : childrenList) {
            List<FilterHavingChildren> childrenInChildrenList;
            List<FilterHavingChildrenRight> childrenRightList = child.getRight();
            if (childrenRightList != null) {
                for (FilterHavingChildrenRight childRight : childrenRightList) {
                    this.datasetObjectMetricAnalyzer(null, childRight.getDatasetObject(), solutionStepIndex, context);
                }
            }
            if ((childrenInChildrenList = child.getChildren()) == null) continue;
            this.filterHavingMetricAnalyzer(childrenInChildrenList, solutionStepIndex, context);
        }
    }

    private Filter createrMetricFilter(Filter filter, String source, int solutionStepIndex, SolutionStepContext context) {
        Filter newFilter = new Filter();
        if (filter != null) {
            newFilter.setLogic(filter.getLogic());
            List<FilterHavingChildren> childrenList = filter.getChildren();
            List<FilterHavingChildren> newChildrenList = this.createFilterOrHavingChildren(childrenList, source, solutionStepIndex, context);
            newFilter.setChildren(newChildrenList);
        }
        return newFilter;
    }

    private Having createMetricHaving(Having having, String source, int solutionStepIndex, SolutionStepContext context) {
        Having newHaving = new Having();
        if (having == null) {
            return newHaving;
        }
        having.setLogic(having.getLogic());
        List<FilterHavingChildren> childrenList = having.getChildren();
        List<FilterHavingChildren> newChildrenList = this.createFilterOrHavingChildren(childrenList, source, solutionStepIndex, context);
        newHaving.setChildren(newChildrenList);
        return newHaving;
    }

    private List<FilterHavingChildren> createFilterOrHavingChildren(List<FilterHavingChildren> childrenList, String source, int solutionStepIndex, SolutionStepContext context) {
        ArrayList<FilterHavingChildren> newChildrenList = new ArrayList<FilterHavingChildren>();
        if (childrenList != null) {
            for (FilterHavingChildren child : childrenList) {
                FilterHavingChildren newChild = new FilterHavingChildren();
                newChild.setLogic(child.getLogic());
                newChild.setOperator(child.getOperator());
                BaseObject newChildLeft = new BaseObject();
                if (child.getLeft() != null && child.getLeft().getSource().equals(source)) {
                    BeanUtils.copyProperties((Object)child.getLeft(), (Object)newChildLeft);
                    newChild.setLeft(newChildLeft);
                } else if (child.getLeft() == null) {
                    newChild.setLeft(null);
                }
                List<FilterHavingChildrenRight> childrenRigthList = child.getRight();
                LOGGER.info("createFilterOrHavingChildren.right:{}", (Object)JSONObject.toJSONString(childrenRigthList));
                if (!CollectionUtils.isEmpty(childrenRigthList)) {
                    ArrayList<FilterHavingChildrenRight> newChildrenRigthList = new ArrayList<FilterHavingChildrenRight>();
                    for (FilterHavingChildrenRight childRight : childrenRigthList) {
                        if (childRight.getDataObject() != null) {
                            FilterHavingChildrenRight newChildRight = new FilterHavingChildrenRight();
                            if (childRight.getDataObject().getSource().equals(source)) {
                                BaseObject newBaseObject = new BaseObject();
                                BeanUtils.copyProperties((Object)childRight.getDataObject(), (Object)newBaseObject);
                                newChildRight.setDataObject(newBaseObject);
                            }
                            newChildrenRigthList.add(newChildRight);
                            continue;
                        }
                        if (childRight.getDatasetObject() == null) continue;
                        Object rightData = null;
                        DatasetObject datasetObject = childRight.getDatasetObject();
                        if ("metric".equals(datasetObject.getDatasetType())) {
                            this.datasetObjectMetricAnalyzer(null, datasetObject, solutionStepIndex, context);
                            rightData = SolutionStepExecutionFacade.getMetricData(datasetObject.getAlias());
                        } else if ("step".equals(datasetObject.getDatasetType())) {
                            if (SolutionStepExecutionFacade.getTransDataMap().containsKey(datasetObject.getStep())) {
                                rightData = SolutionStepExecutionFacade.getTransDataMap().get(datasetObject.getStep());
                                rightData = this.dataValueExtractor.extract(datasetObject.getContent(), child.getOperator(), rightData);
                            }
                        } else if ("subQuery".equals(datasetObject.getDatasetType())) {
                            this.solutionStepExecutionFacade.doSolutionStep(datasetObject.getSubQuery(), context, solutionStepIndex);
                            if (SolutionStepExecutionFacade.getTransDataMap().containsKey(datasetObject.getAlias())) {
                                rightData = SolutionStepExecutionFacade.getTransDataMap().get(datasetObject.getAlias());
                            }
                        }
                        if (rightData == null) {
                            LOGGER.info(String.format("agiledata_%s_\u53f3child\u4e3adatasetObject\u672a\u53d6\u5230\u6570\u636e:%s", "SolutionStepMetricAnalyzer.createFilterOrHavingChildren", JSONObject.toJSONString((Object)childRight.getDatasetObject())));
                            continue;
                        }
                        BaseObject newBaseObject = new BaseObject();
                        newBaseObject.setContentType("const");
                        newBaseObject.setDataType("string");
                        newBaseObject.setSource(source);
                        newBaseObject.setContent((String)rightData);
                        FilterHavingChildrenRight newChildRight = new FilterHavingChildrenRight();
                        newChildRight.setDataObject(newBaseObject);
                        newChildrenRigthList.add(newChildRight);
                    }
                    newChild.setRight(newChildrenRigthList);
                } else {
                    newChild.setRight(null);
                }
                List<FilterHavingChildren> childChildrenList = child.getChildren();
                if (childChildrenList != null) {
                    newChild.setChildren(this.createFilterOrHavingChildren(childChildrenList, source, solutionStepIndex, context));
                }
                newChildrenList.add(newChild);
            }
        }
        LOGGER.info("createFilterOrHavingChildren:{}", (Object)JSONObject.toJSONString(newChildrenList));
        return newChildrenList;
    }

    private List<GroupBy> createMetricGroupBy(List<GroupBy> groupByList, List<Join> joinList, List<Select> selectList, String source) {
        ArrayList<GroupBy> newGroupByList = new ArrayList<GroupBy>();
        if (groupByList == null) {
            groupByList = new ArrayList<GroupBy>();
        }
        ArrayList<GroupBy> onGroupByList = new ArrayList<GroupBy>();
        if (!CollectionUtils.isEmpty(joinList)) {
            for (Join join : joinList) {
                List<On> on = join.getOn();
                for (On onItem : on) {
                    GroupBy groupBy2;
                    if (source.equals(onItem.getLeft().getSource()) && "field".equals(onItem.getLeft().getContentType())) {
                        groupBy2 = new GroupBy();
                        BeanUtils.copyProperties((Object)onItem.getLeft(), (Object)groupBy2);
                        onGroupByList.add(groupBy2);
                    }
                    if (!source.equals(onItem.getRight().getSource()) || !"field".equals(onItem.getRight().getContentType())) continue;
                    groupBy2 = new GroupBy();
                    BeanUtils.copyProperties((Object)onItem.getRight(), (Object)groupBy2);
                    onGroupByList.add(groupBy2);
                }
            }
        }
        newGroupByList.addAll(onGroupByList);
        for (GroupBy groupBy3 : groupByList) {
            if (!groupBy3.getSource().equals(source) || !newGroupByList.stream().noneMatch(item -> item.getContent().equals(groupBy3.getContent()) && item.getSource().equals(groupBy3.getSource()))) continue;
            GroupBy newGroupBy = new GroupBy();
            BeanUtils.copyProperties((Object)groupBy3, (Object)newGroupBy);
            newGroupByList.add(newGroupBy);
        }
        for (Select select : selectList) {
            DataObject dataObject = select.getDataObject();
            if (dataObject == null || dataObject.getDataType().equals("number") || !dataObject.getContentType().equals("field")) continue;
            String content = dataObject.getContent();
            if (!newGroupByList.stream().noneMatch(groupBy -> groupBy.getContent().equals(content))) continue;
            GroupBy newGroupBy = new GroupBy();
            BeanUtils.copyProperties((Object)dataObject, (Object)newGroupBy);
            newGroupByList.add(newGroupBy);
        }
        return newGroupByList;
    }

    public void fetchData(SolutionStepMetric metric, SolutionStepContext context, String dataSetType) {
        MetricResultVo result = ContextUtils.getBean(dataSetType, IScraper.class).fetchData(metric, context);
        JSONObject resultJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)result.getData(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (context.getParam().containsKey("debug") && "true".equals(String.valueOf(context.getParam().get("debug")))) {
            SolutionStepExecutionFacade.setDebugDtoListLocal(result.getDebugDto());
        }
        if (resultJson.get((Object)"data") != null) {
            JSONArray jsonArray = resultJson.getJSONArray("data");
            metric.setData(jsonArray);
            LogUtils.buildAgileLog("getMetricData", LogUtils.SUCCESS, "", "\u6307\u6807\u53d6\u6570\u6210\u529f\uff0c\u5177\u4f53\u6570\u636e\u4e0d\u5c55\u793a", "");
            LOGGER.info(String.format("agiledata_%s_\u53d6\u6307\u6807\u6570\u636e\u51fa\u53c2:\u6307\u6807\u53d6\u6570\u5171\u53d6\u51fa\u6570\u636e%s\u6761", "SolutionStepMetricAnalyzer.getMetricData", jsonArray.size()));
        } else {
            LOGGER.info(String.format("agiledata_%s_\u53d6\u6307\u6807\u6570\u636e\u51fa\u53c2:%s", "SolutionStepMetricAnalyzer.getMetricData", "\u672a\u53d6\u5230\u6570\u636e"));
            LogUtils.buildAgileLog("getMetricData", LogUtils.WARING, "", JSONObject.toJSONString((Object)resultJson), "\u68c0\u67e5\u4e0b\u5165\u53c2\u4e0epulldata\u65e5\u5fd7\uff0c\u68c0\u67e5\u662f\u5426\u53d6\u6570\u8fc7\u7a0b\u4e2d\u5b58\u5728\u95ee\u9898");
        }
    }
}

