/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.execution.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.dto.ExportDataDto;
import com.digiwin.athena.executionengine.dto.runinfo.ActionExecutionDto;
import com.digiwin.athena.executionengine.dto.runinfo.DebugDto;
import com.digiwin.athena.executionengine.model.Metric;
import com.digiwin.athena.executionengine.model.input.ExportInput;
import com.digiwin.athena.executionengine.model.input.SolutinStep.DataObject;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Select;
import com.digiwin.athena.executionengine.model.input.SolutinStep.SolutionStep;
import com.digiwin.athena.executionengine.model.input.SolutionStepInput;
import com.digiwin.athena.executionengine.model.solutionStep.SolutionStepMetric;
import com.digiwin.athena.executionengine.service.facade.analyzer.ISolutionStepMetricAnalyzerFacade;
import com.digiwin.athena.executionengine.service.facade.analyzer.impl.SolutionStepManager;
import com.digiwin.athena.executionengine.service.facade.execution.ISolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.service.facade.export.IExportFacade;
import com.digiwin.athena.executionengine.util.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SolutionStepExecutionFacade
implements ISolutionStepExecutionFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionStepExecutionFacade.class);
    private static final ThreadLocal<List<SolutionStepMetric>> metricLocal = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> transDataLocal = new ThreadLocal();
    private static final ThreadLocal<List<Metric>> exportMetricLocal = new ThreadLocal();
    private static final ThreadLocal<List<DebugDto>> debugDtoListLocal = new ThreadLocal();
    private ISolutionStepMetricAnalyzerFacade solutionStepMetricAnalyzerFacade;
    @Autowired
    private IExportFacade exportFacade;
    private SolutionStepManager solutionStepManager;

    @Autowired
    public void setSolutionStepMetricAnalyzerFacade(ISolutionStepMetricAnalyzerFacade solutionStepMetricAnalyzerFacade) {
        this.solutionStepMetricAnalyzerFacade = solutionStepMetricAnalyzerFacade;
    }

    @Autowired
    public void setSolutionStepManager(SolutionStepManager solutionStepManager) {
        this.solutionStepManager = solutionStepManager;
    }

    @Override
    public Object execute(SolutionStepInput solutionStepInput) {
        try {
            LOGGER.info(String.format("agiledata_%s_\u6307\u6807\u63a5\u6536\u7684\u53c2\u6570:%s \nToken:%s", "SolutionStepExecutionFacade.execute", JSONObject.toJSONString((Object)solutionStepInput), DWServiceContext.getContext().getToken()));
            long startTime = System.currentTimeMillis();
            if (!this.checkSolutionStepParams(solutionStepInput)) {
                Object var4_4 = null;
                return var4_4;
            }
            SolutionStepContext context = this.createSolutionStepContext(solutionStepInput);
            context.setNeedData(true);
            List solutionStepList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)solutionStepInput.getSolutionStep()), SolutionStep.class);
            int solutionStepIndex = 0;
            String lastStepKey = "";
            for (SolutionStep solutionStep : solutionStepList) {
                this.doSolutionStep(solutionStep, context, solutionStepIndex);
                if (transDataLocal.get() != null) {
                    transDataLocal.get().put(solutionStep.getAlias(), this.washResultData(transDataLocal.get().get(solutionStep.getAlias()), solutionStep.getSelect(), solutionStep.getComputeList()));
                }
                if (++solutionStepIndex != solutionStepList.size()) continue;
                lastStepKey = solutionStep.getAlias();
            }
            long timeTaken = System.currentTimeMillis() - startTime;
            LOGGER.info("\u6267\u884c\u5f15\u64ceSolutionStepExecute\u603b\u8017\u65f6 :{}ms", (Object)timeTaken);
            Map<String, Object> dataMap = transDataLocal.get();
            LogUtils.buildAgileLog("analyseSolutionStepDefine", LogUtils.SUCCESS, String.format("\u6307\u6807\u63a5\u6536\u7684\u53c2\u6570:%s  token:%s", JSONObject.toJSONString((Object)solutionStepInput), DWServiceContext.getContext().getToken()), String.format("\u6307\u6807\u63a5\u6536\u7684\u51fa\u53c2:%s ", JSONObject.toJSONString(dataMap)), "\u5982\u679c\u5bf9\u8fd4\u56de\u7ed3\u679c\u6709\u5f02\u8bae\uff0c\u53ef\u4ee5\u67e5\u770b\u540e\u7eed\u8be6\u7ec6\u7684\u6267\u884c\u6b65\u9aa4\u65e5\u5fd7");
            JSONObject response = new JSONObject();
            if (dataMap == null || !dataMap.containsKey(lastStepKey)) {
                LOGGER.info(String.format("agiledata_%s_\u6307\u6807\u63a5\u6536\u7684\u51fa\u53c2:*\u672a\u67e5\u8be2\u5230\u6570\u636e* \nToken:%s", "SolutionStepExecutionFacade.execute", DWServiceContext.getContext().getToken()));
                response.put("data", (Object)new JSONArray());
                JSONObject jSONObject = response;
                return jSONObject;
            }
            List<Object> dictionary = context.getDatasetDictionaryMapping().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            response.put("data", (Object)this.doTranslate((JSONArray)dataMap.get(lastStepKey), dictionary));
            response.put("debug", (Object)this.createDebugInfo(context));
            LOGGER.info(String.format("agiledata_%s_\u6307\u6807\u63a5\u6536\u7684\u51fa\u53c2:%s \nToken:%s", "SolutionStepExecutionFacade.execute", response, DWServiceContext.getContext().getToken()));
            JSONObject jSONObject = response;
            return jSONObject;
        }
        catch (Exception exception) {
            LOGGER.error(String.format("agiledata_%s_\u6307\u6807\u63a5\u6536\u7684\u51fa\u53c2:%s \nToken:%s", "SolutionStepExecutionFacade.execute", exception, DWServiceContext.getContext().getToken()));
            throw exception;
        }
        finally {
            transDataLocal.remove();
            debugDtoListLocal.remove();
            metricLocal.remove();
        }
    }

    private JSONArray doTranslate(JSONArray dataCenterData, List<Object> dictionary) {
        if (CollectionUtils.isEmpty(dictionary) || CollectionUtils.isEmpty((Collection)dataCenterData)) {
            return dataCenterData;
        }
        JSONArray dic = JSONArray.parseArray((String)JSONObject.toJSONString(dictionary));
        HashMap allDicMap = new HashMap();
        dic.stream().forEach(obj -> {
            JSONArray enums = ((JSONObject)obj).getJSONArray("enums");
            String name = ((JSONObject)obj).getString("name");
            JSONObject dicMap = new JSONObject();
            enums.forEach(item -> {
                JSONObject enumItem = (JSONObject)item;
                dicMap.put(enumItem.getString("value"), (Object)enumItem.getString("description"));
            });
            allDicMap.put(name, dicMap);
        });
        dataCenterData.forEach(item -> {
            JSONObject row = (JSONObject)item;
            row.forEach((key, value) -> {
                if (allDicMap.containsKey(key)) {
                    row.put(key, ((JSONObject)allDicMap.get(key)).get((Object)value.toString()));
                }
            });
        });
        return dataCenterData;
    }

    @Override
    public void doSolutionStep(SolutionStep solutionStep, SolutionStepContext context, int solutionStepIndex) {
        this.solutionStepMetricAnalyzerFacade.analyseMetric(solutionStep, context, solutionStepIndex);
        if (context.isNeedData()) {
            this.solutionStepManager.executeSolutionStep(solutionStep, solutionStepIndex, context);
        }
    }

    @Override
    public List<ExportDataDto> export(SolutionStepInput solutionStepInput) {
        try {
            LOGGER.info(String.format("agiledata_%s_\u63a5\u6536\u7684\u53c2\u6570:%s \nToken:%s", "SolutionStepExecutionFacade.export", JSONObject.toJSONString((Object)solutionStepInput), DWServiceContext.getContext().getToken()));
            if (solutionStepInput.getSolutionStep() == null || solutionStepInput.getSolutionStep().isEmpty()) {
                LOGGER.error(String.format("agiledata_%s_\u63a5\u6536\u7684step\u53c2\u6570:%s", "SolutionStepExecutionFacade.export", JSONObject.toJSONString((Object)solutionStepInput.getSolutionStep())));
            }
            SolutionStepContext context = this.createSolutionStepContext(solutionStepInput);
            List solutionStepList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)solutionStepInput.getSolutionStep()), SolutionStep.class);
            int solutionStepIndex = 0;
            for (SolutionStep solutionStep : solutionStepList) {
                this.doSolutionStep(solutionStep, context, solutionStepIndex);
            }
            List<Metric> metricList = exportMetricLocal.get();
            ExportInput exportInput = new ExportInput();
            exportInput.setDatasource(!solutionStepInput.getSysParam().isEmpty() && solutionStepInput.getSysParam().containsKey("dataSource") ? String.valueOf(solutionStepInput.getSysParam().get("dataSource")) : null);
            exportInput.setMetrics(metricList);
            exportInput.setEocMaps(this.convertEocMaps(solutionStepInput.getEocMaps()));
            exportInput.setPermissions(JSONObject.parseObject((String)JSONObject.toJSONString(context.getPermissions())));
            exportInput.setUserId(!solutionStepInput.getSysParam().isEmpty() && solutionStepInput.getSysParam().containsKey("userId") ? String.valueOf(solutionStepInput.getSysParam().get("userId")) : null);
            exportInput.setTenantId(solutionStepInput.getTenantId());
            List<ExportDataDto> list = this.exportFacade.exportData(exportInput);
            return list;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            exportMetricLocal.remove();
            metricLocal.remove();
        }
    }

    private SolutionStepContext createSolutionStepContext(SolutionStepInput solutionStepInput) {
        SolutionStepContext context = new SolutionStepContext();
        context.setTenantId(solutionStepInput.getTenantId());
        context.setEocMaps(this.convertEocMaps(solutionStepInput.getEocMaps()));
        context.setEocMap(solutionStepInput.getEocMaps() == null || solutionStepInput.getEocMaps().isEmpty() ? new HashMap<String, Object>() : solutionStepInput.getEocMaps().get(0));
        context.setParam(solutionStepInput.getSysParam());
        context.setToken(DWServiceContext.getContext().getToken());
        if (solutionStepInput.getExtension() != null && !solutionStepInput.getExtension().isEmpty()) {
            if (solutionStepInput.getExtension().containsKey((Object)"permissions")) {
                JSONObject permissions = solutionStepInput.getExtension().getJSONObject("permissions");
                context.setPermissions((Map)permissions.toJavaObject((TypeReference)new TypeReference<Map<String, Object>>(){}));
                if (permissions.containsKey((Object)"roles")) {
                    context.setRoles((List)permissions.getJSONArray("roles").toJavaObject((TypeReference)new TypeReference<List<String>>(){}));
                } else {
                    context.setRoles(new ArrayList<String>());
                }
            }
            if (solutionStepInput.getExtension().containsKey((Object)"productLineInfo")) {
                context.setProductLineInfo(solutionStepInput.getExtension().getJSONArray("productLineInfo"));
            }
            if (!solutionStepInput.getExtension().isEmpty() && solutionStepInput.getExtension().containsKey((Object)"datasets")) {
                JSONArray datasets = solutionStepInput.getExtension().getJSONArray("datasets");
                List javaObject = (List)datasets.toJavaObject((TypeReference)new TypeReference<List<JSONObject>>(){});
                this.initDatasetInfo(javaObject, context);
            }
        }
        return context;
    }

    private void initDatasetInfo(List<JSONObject> datasets, SolutionStepContext context) {
        datasets.forEach(datasetInfo -> {
            String datasetId = datasetInfo.getString("datasetId");
            String modelId = datasetInfo.getString("modelId");
            String modelCode = datasetInfo.getString("modelCode");
            JSONObject mappingFields = datasetInfo.getJSONObject("mappingFields");
            context.getModelIdMapping().put(datasetId, modelId);
            context.getModelCodeMapping().put(datasetId, modelCode);
            context.getDatasetFieldsMapping().put(datasetId, mappingFields);
            context.getDatasetDictionaryMapping().put(datasetId, datasetInfo.getJSONArray("dictionary"));
        });
    }

    private List<Map<String, Object>> convertEocMaps(List<Map<String, Object>> eocMaps) {
        ArrayList<Map<String, Object>> eocMapList = new ArrayList<Map<String, Object>>();
        if (eocMaps.isEmpty()) {
            return eocMapList;
        }
        for (Map<String, Object> eocMap : eocMaps) {
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            if (eocMap.isEmpty()) continue;
            for (String key : eocMap.keySet()) {
                objectMap.put(key, eocMap.get(key));
            }
            eocMapList.add(objectMap);
        }
        return eocMapList;
    }

    public static Object getMetricData(String alias) {
        SolutionStepMetric metric;
        Optional<SolutionStepMetric> metricOptional;
        List<SolutionStepMetric> metrics = SolutionStepExecutionFacade.getSolutionStepMetrics();
        if (CollectionUtils.isNotEmpty(metrics) && (metricOptional = metrics.stream().filter(solutionStepMetric -> alias.equals(solutionStepMetric.getAlias())).findFirst()).isPresent() && (metric = metricOptional.get()).getData() != null) {
            if (metric.getCount() - 1 == 0) {
                metrics.remove(metric);
            }
            return metric.getData();
        }
        return null;
    }

    private Object washResultData(Object data, List<Select> selectList, JSONObject computeList) {
        LOGGER.info("washResultData\u5f00\u59cb...");
        if (data == null) {
            LOGGER.info("washResultData\u7684\u6570\u636e\u4e3anull\u76f4\u63a5\u8fd4\u56de...");
            return data;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)JSONArray.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (jsonArray.isEmpty()) {
            LOGGER.info("washResultData\u7684\u6570\u636e\u4e3a\u7a7a\u96c6\u5408\u76f4\u63a5\u8fd4\u56de...");
            return data;
        }
        LOGGER.info("washResultData\u7684\u6570\u636e\u6761\u76ee\u6570\u91cf:{}", (Object)jsonArray.size());
        JSONArray newData = new JSONArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONObject newJSONObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject));
            Set keySet = jsonObject.keySet();
            for (String key : keySet) {
                selectList.forEach(select -> {
                    DataObject selectObject = select.getDataObject();
                    if (selectObject != null) {
                        if (!"calculate".equals(selectObject.getContentType())) {
                            if (key.equals(selectObject.getContent()) && !key.equals(selectObject.getAlias())) {
                                String alias = selectObject.getAlias();
                                newJSONObject.put(alias, newJSONObject.get((Object)key));
                                newJSONObject.remove((Object)key);
                            }
                        } else {
                            JSONArray computeArray = computeList.getJSONArray(selectObject.getContent());
                            JSONObject lastComputeObject = computeArray.getJSONObject(computeArray.size() - 1);
                            String newField = lastComputeObject.getString("newField");
                            if (key.equals(newField) && !key.equals(selectObject.getAlias())) {
                                String alias = selectObject.getAlias();
                                newJSONObject.put(alias, newJSONObject.get((Object)key));
                                newJSONObject.remove((Object)key);
                            }
                        }
                    }
                });
            }
            newData.add((Object)newJSONObject);
        }
        return newData;
    }

    public JSONObject createDebugInfo(SolutionStepContext context) {
        JSONObject jsonObject = new JSONObject();
        if (context.getParam().containsKey("debug") && "true".equals(String.valueOf(context.getParam().get("debug")))) {
            List<DebugDto> debugDtoList = SolutionStepExecutionFacade.getDebugDtoListLocal();
            JSONArray metricRunningInfoArray = new JSONArray();
            JSONObject metricRunningDetail = new JSONObject();
            for (DebugDto debugDto : debugDtoList) {
                JSONObject metricRunningInfo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)debugDto.getMetricExecutionDto()));
                metricRunningInfoArray.add((Object)metricRunningInfo);
                if (debugDto.getActionExecutionDtosMap() == null) continue;
                for (Map.Entry<String, List<ActionExecutionDto>> entry : debugDto.getActionExecutionDtosMap().entrySet()) {
                    List<ActionExecutionDto> actionExecutionDtoList = entry.getValue();
                    Collections.reverse(actionExecutionDtoList);
                    metricRunningDetail.put(entry.getKey(), (Object)JSONObject.parseArray((String)JSONObject.toJSONString(actionExecutionDtoList)));
                }
            }
            jsonObject.put("metricRunningInfo", (Object)metricRunningInfoArray);
            jsonObject.put("metricRunningDetail", (Object)metricRunningDetail);
        }
        return jsonObject;
    }

    public boolean checkSolutionStepParams(SolutionStepInput solutionStepInput) {
        if (solutionStepInput.getSysParam() == null || solutionStepInput.getSysParam().isEmpty()) {
            LogUtils.buildAgileLog("analyseSolutionStepDefine", LogUtils.SUCCESS, String.format("\u6307\u6807\u63a5\u6536\u7684\u53c2\u6570:%s  token:%s", JSONObject.toJSONString((Object)solutionStepInput), DWServiceContext.getContext().getToken()), "\u6307\u6807\u63a5\u6536\u7684\u51fa\u53c2:{null}", "\u8c03\u7528\u5165\u53c2\u7f3a\u5c11sysParam\u5185\u5bb9\uff0c\u786e\u8ba4\u8fb9\u7f18\u6570\u636e\u4e2d\u53f0\u5f53\u524d\u662f\u5426\u6709\u53d1\u7248\u64cd\u4f5c");
            return false;
        }
        if (solutionStepInput.getSolutionStep() == null || solutionStepInput.getSolutionStep().isEmpty()) {
            LogUtils.buildAgileLog("analyseSolutionStepDefine", LogUtils.SUCCESS, String.format("\u6307\u6807\u63a5\u6536\u7684\u53c2\u6570:%s  token:%s", JSONObject.toJSONString((Object)solutionStepInput), DWServiceContext.getContext().getToken()), "\u6307\u6807\u63a5\u6536\u7684\u51fa\u53c2:{null}", "\u8c03\u7528\u5165\u53c2\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u8bed\u4e49\u76f8\u5173\u4eba\u5458\u6392\u67e5\u8bed\u4e49\u5206\u6790\u5426\u5b58\u5728\u95ee\u9898");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)solutionStepInput.getTenantId())) {
            LogUtils.buildAgileLog("analyseSolutionStepDefine", LogUtils.SUCCESS, String.format("\u6307\u6807\u63a5\u6536\u7684\u53c2\u6570:%s  token:%s", JSONObject.toJSONString((Object)solutionStepInput), DWServiceContext.getContext().getToken()), "\u6307\u6807\u63a5\u6536\u7684\u51fa\u53c2:{null}", "\u8c03\u7528\u5165\u53c2\u7f3a\u5c11TenantId\uff0c\u8bf7\u8054\u7cfb\u654f\u6377\u6570\u636e\u5f15\u64ce(ade)\u76f8\u5173\u4eba\u5458\u68c0\u67e5\u4ed6\u4eec\u8c03\u7528\u662f\u5426\u5b58\u5728\u95ee\u9898");
            return false;
        }
        for (int i = 0; i < solutionStepInput.getSolutionStep().size(); ++i) {
            JSONObject jsonObject = solutionStepInput.getSolutionStep().getJSONObject(i);
            JSONArray selectArray = jsonObject.getJSONArray("select");
            for (int j = 0; j < selectArray.size(); ++j) {
                JSONObject selectObject = selectArray.getJSONObject(j);
                JSONObject dataObject = selectObject.getJSONObject("dataObject");
                if (dataObject != null && dataObject.containsKey((Object)"dataType") && dataObject.containsKey((Object)"alias") && dataObject.containsKey((Object)"contentType") && dataObject.containsKey((Object)"content")) continue;
                LogUtils.buildAgileLog("analyseSolutionStepDefine", LogUtils.SUCCESS, String.format("\u6307\u6807\u63a5\u6536\u7684\u53c2\u6570:%s  token:%s", JSONObject.toJSONString((Object)solutionStepInput), DWServiceContext.getContext().getToken()), "\u6307\u6807\u63a5\u6536\u7684\u51fa\u53c2:{null}", "\u8c03\u7528\u5165\u53c2\u7684select\u5185\u5bb9\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u8bed\u4e49\u76f8\u5173\u4eba\u5458\u6392\u67e5\u8bed\u4e49\u5206\u6790\u5426\u5b58\u5728\u95ee\u9898");
                return false;
            }
        }
        return true;
    }

    public static List<SolutionStepMetric> getSolutionStepMetrics() {
        if (metricLocal.get() == null) {
            metricLocal.set(new ArrayList());
        }
        return metricLocal.get();
    }

    public static void setSolutionStepMetrics(List<SolutionStepMetric> solutionStepMetrics) {
        metricLocal.set(solutionStepMetrics);
    }

    public static void releaseSolutionStepMetrics() {
        metricLocal.remove();
    }

    public static Map<String, Object> getTransDataMap() {
        return transDataLocal.get();
    }

    public static void setTransDataMap(Map<String, Object> transDataMap) {
        transDataLocal.set(transDataMap);
    }

    public static void releaseTransDataMap() {
        transDataLocal.remove();
    }

    public static List<Metric> getExportMetrics() {
        if (exportMetricLocal.get() == null) {
            exportMetricLocal.set(new ArrayList());
        }
        return exportMetricLocal.get();
    }

    public static void setExportMetrics(List<Metric> exportMetrics) {
        exportMetricLocal.set(exportMetrics);
    }

    public static void releaseExportMetrics() {
        exportMetricLocal.remove();
    }

    public static List<DebugDto> getDebugDtoListLocal() {
        if (debugDtoListLocal.get() == null) {
            debugDtoListLocal.set(new ArrayList());
        }
        return debugDtoListLocal.get();
    }

    public static void setDebugDtoListLocal(DebugDto debugDto) {
        if (debugDtoListLocal.get() == null) {
            debugDtoListLocal.set(new ArrayList());
        }
        debugDtoListLocal.get().add(debugDto);
    }
}

