package com.digiwin.athena.executionengine.model.trans;

import java.util.List;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2021/5/7
 */
public class FilterItem {
    /**
     * 逻辑类型
     * and
     * or
     * single (单个条件)
     */
    private String logiType;

    /**
     * 比较符左边值
     */
    private String left;

    /**
     * 比较符左边值类型
     */
    private String leftValueType;

    /**
     * 操作类型 eq lte gte 等
     */
    private String op;

    /**
     * 比较符右边值
     */
    private String right;

    /**
     * 比较符 右边值类型
     */
    private String rightValueType;

    /**
     * 比较符 右边值来源
     * constant 来自常量
     * var 来自机制变量
     * column 来自step输入数据
     */
    private String type;

    /**
     * 日期格式类型 当leftValuetype为datetime时，此属性需要配置，其他类型可不配置
     * yyyy-mm-dd HH:mm:ss
     */
    private String leftDateFormat;

    /**
     * 日期格式类型 当rightValuetype为datetime时，此属性需要配置，其他类型可不配置
     * yyyy-mm-dd HH:mm:ss
     */
    private String rightDateFormat;


    /**
     * 嵌套子条件集合
     */
    private List<FilterItem> filterItems;

    public List<FilterItem> getFilterItems() {
        return filterItems;
    }

    public void setFilterItems(List<FilterItem> filterItems) {
        this.filterItems = filterItems;
    }

    public String getLeftDateFormat() {
        return leftDateFormat;
    }

    public void setLeftDateFormat(String leftDateFormat) {
        this.leftDateFormat = leftDateFormat;
    }

    public String getRightDateFormat() {
        return rightDateFormat;
    }

    public void setRightDateFormat(String rightDateFormat) {
        this.rightDateFormat = rightDateFormat;
    }

    public String getLogiType() {
        return logiType;
    }

    public void setLogiType(String logiType) {
        this.logiType = logiType;
    }

    public String getLeft() {
        return left;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public String getLeftValueType() {
        return leftValueType;
    }

    public void setLeftValueType(String leftValueType) {
        this.leftValueType = leftValueType;
    }

    public String getOp() {
        return op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getRight() {
        return right;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public String getRightValueType() {
        return rightValueType;
    }

    public void setRightValueType(String rightValueType) {
        this.rightValueType = rightValueType;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
