package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.input.SolutinStep.DatasetObject;
import com.digiwin.athena.executionengine.model.input.SolutinStep.SolutionStep;
import com.digiwin.athena.executionengine.service.facade.analyzer.ISolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.util.ContextUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service("datasetObjectStep")
public class DatasetObjectSolutionStepAnalyzer implements ISolutionStepAnalyzer {

    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetObjectSolutionStepAnalyzer.class);

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, ISolutionStepAnalyzer nextStep, SolutionStepContext context) {

    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        DatasetObject datasetObject = solutionStep.getDatasetObject();
        String strStepIndex = stepIndex + "-" + solutionStep.getAlias();
        LOGGER.info("datasetObjectStep开始执行datasetObject==null:{}", datasetObject == null ? "true" : "false");
        String datasetType = datasetObject.getDatasetType();
        if (datasetObject != null) {
            if (CommonConstant.METRIC.equalsIgnoreCase(datasetType)
                    || CommonConstant.METRIC_DATASET.equalsIgnoreCase(datasetType) || CommonConstant.DATASET.equals(datasetType)){
                Object data = SolutionStepExecutionFacade.getMetricData(datasetObject.getAlias());
                if (data != null) {
                    Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                    if (dataMap != null) {
                        dataMap.put(strStepIndex, data);
                    } else {
                        dataMap = new HashMap<>();
                        dataMap.put(strStepIndex, data);
                    }
                    SolutionStepExecutionFacade.setTransDataMap(dataMap);
                }
            } else if ("step".equals(datasetObject.getDatasetType())) {
                //取出步骤数据放入当前步骤
                Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                if (dataMap != null && dataMap.containsKey(datasetObject.getStep())) {
                    dataMap.put(strStepIndex, dataMap.get(datasetObject.getStep()));
                }
            } else if ("subQuery".equals(datasetObject.getDatasetType())) {
                //将别名透传，用于后面取数据
                datasetObject.getSubQuery().setAlias(solutionStep.getAlias());
                executeStep(datasetObject.getSubQuery(), stepIndex, context);
            }
        }
        if (solutionStep.getJoin() != null && CollectionUtils.isNotEmpty(solutionStep.getJoin())) {
            ISolutionStepAnalyzer joinStep = ContextUtils.getBean("joinStep");
            joinStep.executeStep(solutionStep, stepIndex, context);
        } else if (solutionStep.getFilter() != null && CollectionUtils.isNotEmpty(solutionStep.getFilter().getChildren())) {
            ISolutionStepAnalyzer filterStep = ContextUtils.getBean("filterStep");
            filterStep.executeStep(solutionStep, stepIndex, context);
        } else {
            ISolutionStepAnalyzer selectStep = ContextUtils.getBean("selectStep");
            selectStep.executeStep(solutionStep, stepIndex, context);
        }
    }
}
