package com.digiwin.athena.executionengine.service.facade.schema.datacenter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.dto.schema.DateFormatDto;
import com.digiwin.athena.executionengine.dto.schema.SchemaTransDto;
import com.digiwin.athena.executionengine.service.facade.schema.AbstractSchemaConvertor;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2025/5/19
 */
@Service
public class DataCenterSelectConvertor extends AbstractSchemaConvertor {
    @Override
    public void convert(SchemaTransDto schemaTransDto) {

        //区分dataType 1-聚合数据，2-明细数据

        JSONArray selects = (JSONArray) schemaTransDto.getDynamicSchema();
        JSONObject computeObj = schemaTransDto.getComputeObj();
        if (CollectionUtils.isEmpty(selects)) {
            return;
        }

        JSONObject mappingFields = (JSONObject) schemaTransDto.getReqData();
        List<JSONObject> calculateObj = selects.stream().map(o -> ((JSONObject) o).getJSONObject("dataObject")).filter(item -> FieldNameConstant.DYNAMIC_SCHEMA_CALCULATE.equals(item.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT_TYPE))).filter(item -> "number".equals(item.getString("dataType"))).collect(Collectors.toList());

        if (CollectionUtils.isEmpty(calculateObj)) {
            //没有度量字段，代表是明细查询
            schemaTransDto.getQuerySchema().put("dataType", 2);
            handleSelect(schemaTransDto.getQuerySchema(), selects, mappingFields);
            handleDateCompute(schemaTransDto, selects, mappingFields);
            return;
        }

        calculateObj.forEach(select -> {
            JSONObject sObj = (JSONObject) select;
            schemaTransDto.getQuerySchema().getJSONArray("measures").add(genMeasureObj(sObj, computeObj, mappingFields));
        });
    }

    private void handleDateCompute(SchemaTransDto schemaTransDto, JSONArray selects, JSONObject mappingFields) {
        //calculate 只处理日期类型
        List<JSONObject> calculateObj = selects.stream().map(o -> (JSONObject) o).filter(item -> FieldNameConstant.DYNAMIC_SCHEMA_CALCULATE.equals(item.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT_TYPE))).collect(Collectors.toList());

        if (CollectionUtils.isEmpty(calculateObj)) {
            return;
        }

        JSONObject computeObj = schemaTransDto.getComputeObj();

        List<DateFormatDto> dateFormatDtos = new ArrayList<>();
        calculateObj.forEach(item -> {
            String content = item.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT);
            JSONArray computeList = computeObj.getJSONArray(content);
            if (CollectionUtils.isEmpty(computeList)) {
                return;
            }

            computeList.forEach(o -> {
                JSONObject computeItem = (JSONObject) o;
                String calFunction = computeItem.getString("calFunction");
                //只处理日期类型
                if ("DateFormat".equals(calFunction)) {
                    JSONArray params = computeItem.getJSONArray("params");
                    JSONObject fieldParam = params.getJSONObject(0);
                    JSONObject formatParam = params.getJSONObject(1);

                    String field = fieldParam.getString("content");
                    String fieldType = fieldParam.getString("dataType");
                    String format = formatParam.getString("content");
                    DateFormatDto dateFormatDto = new DateFormatDto(field, CommonConstant.DATA_CENTER_FUNCTION_MAP.get(format));
                    dateFormatDto.setFieldType(fieldType);
                    dateFormatDtos.add(dateFormatDto);
                }
            });
        });

        if (CollectionUtils.isNotEmpty(dateFormatDtos)) {
            //拼接computeList
            dateFormatDtos.forEach(dateFormatDto -> {
                JSONObject computeObject = new JSONObject();
                computeObject.put("field", dateFormatDto.getField());
                computeObject.put("dataType", dateFormatDto.getFieldType().toUpperCase());
                computeObject.put("expression", "date_format([" + dateFormatDto.getField() + "],'" + dateFormatDto.getFormat() + "')");
                schemaTransDto.getQuerySchema().getJSONArray("computedFields").add(computeObject);

                //也需要拼接到group中
                JSONObject groupObject = new JSONObject();
                //需要和computeFields保持一致
                groupObject.put("field", dateFormatDto.getField());
                groupObject.put("name", dateFormatDto.getField());
                groupObject.put("dataType", dateFormatDto.getFieldType().toUpperCase());
                if (!dimensionsIsExist(schemaTransDto.getQuerySchema(), dateFormatDto.getField())) {
                    schemaTransDto.getQuerySchema().getJSONArray("dimensions").add(groupObject);
                }
            });
        }
    }

    /**
     * 处理selects节点
     *
     * @param querySchema
     * @param selects
     * @param mappingFields
     */
    private void handleSelect(JSONObject querySchema, JSONArray selects, JSONObject mappingFields) {
        selects.forEach(select -> {
            JSONObject obj = (JSONObject) select;
            JSONObject dataObj = obj.getJSONObject("dataObject");
            String contentType = dataObj.getString("contentType");
            if (!"calculate".equals(contentType)) {
                String dataType = dataObj.getString("dataType");
                String content = dataObj.getString("content");
                JSONObject groupObject = new JSONObject();
                groupObject.put("field", mappingFields.getString(content));
                groupObject.put("name", content);
                groupObject.put("dataType", dataType.toUpperCase());
                if (!dimensionsIsExist(querySchema, content)) {
                    querySchema.getJSONArray("dimensions").add(groupObject);
                }
            }
        });
    }

    private JSONObject genMeasureObj(JSONObject dataObject, JSONObject computeObj, JSONObject mappingFields) {
        String content = dataObject.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT);
        JSONArray computeList = computeObj.getJSONArray(content);
        JSONObject funObj = computeList.getJSONObject(0);
        String function = funObj.getString("calFunction");
        JSONObject measureObj = new JSONObject();

        JSONObject aggregator = new JSONObject();
        aggregator.put("function", function);
        aggregator.put("distinct", false);
        measureObj.put("aggregator", aggregator);

        JSONArray params = funObj.getJSONArray("params");
        JSONObject fieldParam = params.getJSONObject(0);

        String field = fieldParam.getString("content");
        String dataType = fieldParam.getString("dataType");
        measureObj.put("field", mappingFields.getString(field));
        measureObj.put("name", field);
        measureObj.put("dataType", dataType.toUpperCase());

        return measureObj;
    }
}
