package com.digiwin.athena.executionengine.trans;

import com.digiwin.athena.executionengine.constant.TransConstant;
import com.digiwin.athena.executionengine.model.trans.DealResult;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * @description: 数据处理的模板类
 * @author: xijj
 * @date: 2020/08/11 15:13
 */
public abstract class TransAbstractStep implements ITransStep {

    @Override
    public int dealData(Step step) {
        // 子类按照自己的特性进行数据处理
        DealResult dataResult = doDealData(step);
        if (dataResult.getResult() != TransConstant.TRANS_FAIL) {
            // 机制变量这里返回为null，机制变量的结果单独保存
            if (dataResult.getData() != null) {
                getTransDataManager().setCurrentData(step.getName(), dataResult.getData());
            }
        }
        return dataResult.getResult();
    }

    /**
     * 获取当前数据
     *
     * @param name
     * @return
     */
    protected Object getCurrentData(String name) {
        return getTransDataManager().getCurrentData(name);
    }

    /**
     * 获取TransDataManager对象
     * @return
     */
    protected TransDataManger getTransDataManager() {
        return TransEngine.getLocalContext();
    }


    /**
     * 默认路径是单路径，只从一个来源获取数据
     *
     * @return
     */
    protected Object getCurrentData(List<String> prevStepNameList) {
        //如果没有前置节点，那么就直接从originData中取数据
        if (CollectionUtils.isNotEmpty(prevStepNameList)) {
            return getTransDataManager().getCurrentData(prevStepNameList.get(0));
        } else {
            return getTransDataManager().getOriginData();
        }
    }

    /**
     * 判断是否为表状数据
     *
     * @param inputData
     * @return
     */
    protected boolean isTableStructure(Object inputData) {
        //非表状数据
        if (!(inputData instanceof List)) {
            return false;
        }
        //非List<Map> 结构 直接返回
        List dataList = (List) inputData;
        if (CollectionUtils.isNotEmpty(dataList) && !(dataList.get(0) instanceof Map)) {
            return false;
        }
        return true;
    }

    /**
     * 默认路径是单路径，只从一个来源获取数据
     *
     * @return
     */
    protected Object getOriginData() {
        return getTransDataManager().getOriginData();
    }

    /**
     * 子类实现数据的具体处理
     *
     * @param step
     * @return
     * @throws Exception
     */
    protected abstract DealResult doDealData(Step step);

    /**
     * 子类实现自己的规则的校验方法
     *
     * @param stepElement
     * @return
     */
    @Override
    public abstract boolean defineCheck(StepElement stepElement);

}
