package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.aop.ExceptionRetry;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

/**
 * @description:
 * @author: renwm
 * @date: 2020/7/8 18:04
 */
@Service("EocAction")
public class EocAction extends ActionBase {

    private static final Logger LOGGER = LoggerFactory.getLogger(EocAction.class);


    private static final String DIGI_MIDDLEWARE_AUTH_USER = "digi-middleware-auth-user";
    private static final String RESPONSE_CODE = "code";

    @Override
    @ExceptionRetry
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject metaObj = actionParam.getMetaObj();
        String url = metaObj.getString(MetaDataConstant.ACTION_URL);
        String method = metaObj.getString(MetaDataConstant.ACTION_METHOD);

        JSONObject actionJson = actionParam.getActionJson();
        String allocateType = actionJson.getString(MetaDataConstant.ACTION_ALLOCATE_TYPE);

        try {

            Map<String, String> header = new HashMap<>();
            header.put(DIGI_MIDDLEWARE_AUTH_USER, context.getToken());
            header.put(CommonConstant.HTTP_HEADER_CONTENT_TYPE_KEY, CommonConstant.HTTP_HEADER_CONTENT_TYPE_VULE);
            String iamApToken = ModuleProperty.MULTIPLEAPPENV?ModuleProperty.MERGED_IAM_APP_TOKEN:ModuleProperty.APP_TOKEN_VALUE;
            if (StringUtils.isEmpty(iamApToken)) {
                iamApToken = (String) DWServiceContext.getContext().getRequestHeader().getOrDefault(FieldNameConstant.APP_TOKEN, "");
            }
            header.put(FieldNameConstant.APP_TOKEN, iamApToken);
            String actionUrl = ModuleProperty.EOC_DOMAIN_URL + url;
            String httpContent = HttpClientUtils.doRequest(method, actionUrl, header, reqMap);
            LOGGER.info("执行引擎调用EOC执行{}:{}返回的结果为：{}", actionUrl, reqMap, httpContent);

            if (StringUtils.isBlank(httpContent)) {
                return null;
            }
            JSONObject respObj = JSON.parseObject(httpContent);

            if (ModuleProperty.RESPONSE_SUCCESS_STATUS != respObj.getIntValue(RESPONSE_CODE)) {
                context.setExecuteStatus(false);
                return null;
            }

            if (MetaDataConstant.ACTION_ALLOCATETYPE.equals(allocateType)) {
                JSONArray jsonArrayData = respObj.getJSONArray("data");
                if (null != jsonArrayData && jsonArrayData.size() > 1) {
                    JSONArray jsonArray = new JSONArray();
                    jsonArray.add(jsonArrayData.get(ThreadLocalRandom.current().nextInt(jsonArrayData.size() - 1)));// NOSONAR
                    respObj.put("data", jsonArray);
                }
            }
            context.setExecuteStatus(true);
            return respObj;
        } catch (Exception e) {
            LOGGER.error("执行引擎触发EOC[{}]异常:{}", url, e);
            context.setExecuteStatus(false);
            throw e;
        }
    }
}
