package com.digiwin.athena.executionengine.component.param;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: renwm
 * @date: 2020/6/15 9:31
 */
public class ConstantParam extends ParamBase {

    @Override
    protected void initProperty(JSONObject paramObj) {

    }

    @Override
    public boolean eval(ExecuteContext context) {
        return true;
    }

    /**
     * 表明这个数据来自常量的获取
     *
     * @param context
     * @return
     */
    @Override
    public String getSrcActionId(ExecuteContext context) {
        return "ConstantParam";
    }

    @Override
    public Object getData(ExecuteContext context, String jsonPath) {
        return value;
    }

    @Override
    public Object getData(ExecuteContext context, DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return value;
    }

    @Override
    public int getDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath, String jsonPath) {
        return 1;
    }

    @Override
    public int getRootSize(DataMappingManager dataMappingManager, String requestActionId) {
        return 1;
    }

    @Override
    public List<String> getCollectionPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return new ArrayList<>();
    }

    @Override
    public boolean isCollectionRoot(DataMappingManager dataMappingManager, String requestActionId) {
        return false;
    }

    @Override
    public boolean isCollectionParam(DataMappingManager dataMappingManager, String requestActionId, String param) {
        return false;
    }

    @Override
    public boolean isObjectCollectionParam(DataMappingManager dataMappingManager, String requestActionId, String param) {
        return false;
    }

    @Override
    public int getPathDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath, String fixedPath) {
        return 1;
    }

    /**
     * 根据paramPath，获取上一级节点的实际路径作为限定范围路径，取该范围路径下的数据量
     * @param dataMappingManager
     * @param requestActionId
     * @param paramPath
     * @return
     */
    @Override
    public int getPathDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return 1;
    }

    @Override
    public boolean pathIsExistsInData(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return true;
    }

    @Override
    public int countCollectionInPath(DataMappingManager dataMappingManager, String requestActionId, String param) {
        return 0;
    }

    /**
     * 通过参数映射关系设置数据的实际下标
     * @param paramPath
     * @param pos
     */
    @Override
    public void setParentPathPos(DataMappingManager dataMappingManager, String requestActionId, String paramPath, int pos) {
        //该数据并不在dataMapping上，所以这个方法在这里没有意义
    }

    /**
     * 通过参数映射关系获取数据的实际下标
     * @param paramPath
     */
    @Override
    public void setPathPos(DataMappingManager dataMappingManager, String requestActionId, String paramPath, int pos) {
        ///常量不存在数据之间的关系，直接映射值就可以了，所以这个方法在这里没有意义
    }

    /**
     * 通过参数映射关系获取数据的真实的JsonPath
     * @param paramPath
     */
    @Override
    public String getDataJsonPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        //暂时没有实现
        return "";
    }

}
