package com.digiwin.athena.executionengine.enumtype;

/**
 * @description: 操作类型
 * @author: renwm
 * @date: 2020/6/12 14:27
 */
public enum OperatorTypeEnum {

    /**
     * 等于
     */
    EQ("eq","EqOperator","等于"),

    /**
     * 不等于
     */
    NEQ("neq","NeqOperator","不等于"),

    /**
     * 大于
     */
    GT("gt","GtOperator","大于"),

    /**
     * 大于等于
     */
    GTE("gte","GteOperator","大于等于"),

    /**
     * 小于
     */
    LT("lt","LtOperator","小于"),

    /**
     * 等于
     */
    LTE("lte","LteOperator","等于"),

    /**
     * 且
     */
    AND("and","AndOperator","且"),

    /**
     * 或者
     */
    OR("or","OrOperator","或者"),

    /**
     * 未知类型
     */
    UNKNOWN("unknown","","未知类型");

    String type;
    String desc;
    String className;

    OperatorTypeEnum(String type, String className, String desc) {
        this.type = type;
        this.className = className;
        this.desc = desc;
    }

    public static OperatorTypeEnum getEnumByType(String type) {
        for (OperatorTypeEnum itemEnum : OperatorTypeEnum.values()) {

            if (itemEnum.getType().equals(type)) {
                return itemEnum;
            }
        }
        return UNKNOWN;
    }


    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public String getClassName() {
        return className;
    }
}
