package com.digiwin.athena.executionengine.service.facade.mapping.test;

import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingHandler;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;

/**
 * @description:
 * @author: fenglei
 * @date:
 */
public class DataMappingTestUtil {

    public ExecuteContext context;
    public DataMappingManager dataMappingManager;
    public CaseModule testCase;

    public DataMappingTestUtil(CaseModule testCase, ExecuteContext context,
                               DataMappingManager dataMappingManager) {
        this.testCase = testCase;
        this.context = context;
        context.addActionResponse(testCase.rspActionId, testCase.response, testCase.isForeach,"");
        this.dataMappingManager = dataMappingManager;

    }

    private void checkRes(Object res) {
        if (testCase.testRes != null) {
            String oStr = testCase.caseName;
            if (testCase.testRes.equals(res)) {
                oStr = oStr + "  ----> [OK]";
            } else {
                oStr = oStr + "  ----> [Failed] \n Expect: " + testCase.testRes + "\n Result: " + res;
            }

            System.out.println(oStr);
        }
    }

    /**
     * 只用于创建和拾取pack
     */
    public void runGetDataMappingHandler() {
        DataMappingHandler handler =
                dataMappingManager.getDatMappingHandler(testCase.reqActionId,
                        testCase.rspActionId);
    }

    public void runGetJsonByParamPath() {
        DataMappingHandler handler =
                dataMappingManager.getDatMappingHandler(testCase.reqActionId,
                        testCase.rspActionId);
        checkRes(handler.getConcreteJson(testCase.paramPath));
    }

    public void runGetZoneDataSize() {
        DataMappingHandler handler =
                dataMappingManager.getDatMappingHandler(testCase.reqActionId,
                        testCase.rspActionId);
        checkRes(handler.getZoneDataSize(testCase.paramPath));
    }

    public void runGetZoneDataSizeByJpath() {
        DataMappingHandler handler =
                dataMappingManager.getDatMappingHandler(testCase.reqActionId,
                        testCase.rspActionId);
        checkRes(handler.getZoneDataSize(testCase.paramPath, testCase.fixedPath));
    }

    public void runGetPathDataSize() {
        DataMappingHandler handler =
                dataMappingManager.getDatMappingHandler(testCase.reqActionId,
                        testCase.rspActionId);
        checkRes(handler.getPathDataSize(testCase.paramPath, testCase.fixedPath));
    }

    public void runCountCollectionInPath() {
        DataMappingHandler handler =
                dataMappingManager.getDatMappingHandler(testCase.reqActionId,
                        testCase.rspActionId);
        checkRes(handler.countCollectionInPath(testCase.paramPath));
    }

    public void runGetCollectionParamPathList() {
        DataMappingHandler handler =
                dataMappingManager.getDatMappingHandler(testCase.reqActionId,
                        testCase.rspActionId);
        checkRes(handler.getCollectionParamPathList(testCase.paramPath));
    }

    public void runNext(int times) {
        DataMappingHandler handler =
                dataMappingManager.getDatMappingHandler(testCase.reqActionId,
                        testCase.rspActionId);

        System.out.println("步进执行前：JsonPath: " + handler.getConcreteJson(testCase.paramPath));
        for (int i = 0; i < times; i++) {
            handler.next(testCase.paramPath, null);
            System.out.println("第" + String.valueOf(i + 1) + "步：JsonPath: " + handler.getConcreteJson(testCase.paramPath));
        }
    }
}
