package com.digiwin.athena.executionengine.service.facade.schema.dynamic;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2025/2/10
 */
@Service
public class FilterBuilder extends AbstractDynamicCalculateBuilder {
    @Override
    public JSONObject build(Object dynamicSchema, ActionParam actionParam) {

        JSONObject filterObj = null;
        if (dynamicSchema instanceof JSONObject) {
            filterObj = (JSONObject) dynamicSchema;
        } else if (dynamicSchema instanceof Map) {
            filterObj = JSONObject.parseObject(JSONObject.toJSONString(dynamicSchema));
        }

        // Create the new structure
        JSONObject result = new JSONObject();
        result.put("name", "filter");
        result.put("technique", "filter");
        result.put("isEject", true);

        // Create "condition" field
        JSONObject condition = new JSONObject();
        condition.put("logitype", filterObj.getString("logic"));
        JSONArray items = new JSONArray();
        condition.put("items", items);

        JSONArray children = filterObj.getJSONArray("children");
        for (int i = 0; i < children.size(); i++) {
            JSONObject child = children.getJSONObject(i);
            String dateType = child.getJSONObject("left").getString("dataType");
            if ("datetime".equals(dateType)) {
                continue;
            }


            JSONObject dataObject = child.getJSONArray("right").getJSONObject(0).getJSONObject("dataObject");
            String content = dataObject.getString("content");
            String rightDataType = dataObject.getString("dataType");
            String contentType = dataObject.getString("contentType");
            if (!"const".equals(contentType)) {
                continue;
            }


            String leftField = child.getJSONObject("left").getString("content");
            JSONObject actionResFieldsMapping = actionParam.getStandardParameterMapping();
            if (!keyExists(leftField, actionResFieldsMapping)) {
                continue;
            }

            JSONObject conditionItem = new JSONObject();
            conditionItem.put("op", child.getString("operator"));
            conditionItem.put("left", leftField);
            conditionItem.put("logitype", "single");
            conditionItem.put("left_value_type", dateType);


            conditionItem.put("right_value_type", rightDataType);
            conditionItem.put("right", content);
            conditionItem.put("type", "constant");

            items.add(conditionItem);
        }

        result.put("condition", condition);
        return result;
    }
}
