/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.BusinessException;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="FormulaAction")
public class FormulaAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormulaAction.class);
    private static final String SCRIPT_ENGINE_SHORT_NAME = "nashorn";

    @Override
    public Object actionExecute(ExecuteContext context, Map<String, Object> exprParams, ActionParam actionParam) {
        JSONObject actionJson = actionParam.getActionJson();
        String expression = actionJson.getString("expression");
        String target = actionJson.getString("target");
        if (StringUtils.isEmpty((CharSequence)expression)) {
            LOGGER.warn("\u6267\u884c\u5f15\u64ce\u6267\u884c{} Formula {} \u6ca1\u6709\u5bf9\u5e94\u7684\u53c2\u6570\u8868\u8fbe\u5f0f", (Object)actionParam.getActionId(), (Object)expression);
            context.setExecuteStatus(false);
            return null;
        }
        try {
            Object result = this.doExpression(expression, exprParams);
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            returnMap.put(target, result);
            context.setExecuteStatus(true);
            return returnMap;
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u5f15\u64ceFormula[{}]\u6267\u884c\u8868\u8fbe\u5f0f\u5f02\u5e38:{}", (Object)actionParam.getActionId(), (Object)e);
            context.setExecuteStatus(false);
            throw new BusinessException(ErrorCodeEnum.FORMULA_EXECUTE_EXCEPTION.getCode(), ErrorCodeEnum.FORMULA_EXECUTE_EXCEPTION.getMessage(), e);
        }
    }

    public Object doExpression(String expression, Map<String, Object> exprParams) throws Exception {
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName(SCRIPT_ENGINE_SHORT_NAME);
        SimpleScriptContext ctx = new SimpleScriptContext();
        ctx.setBindings(engine.createBindings(), 100);
        String runExpr = expression;
        if (MapUtils.isNotEmpty(exprParams)) {
            for (Map.Entry<String, Object> params : exprParams.entrySet()) {
                runExpr = runExpr.replace(params.getKey(), String.valueOf(params.getValue()));
            }
        }
        return engine.eval(runExpr, (ScriptContext)ctx);
    }
}

