/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.aop.ActionMock;
import com.digiwin.athena.executionengine.core.aop.Debug;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.model.ServiceResult;
import com.digiwin.athena.executionengine.service.client.IIAMClient;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.LogUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="MicroTransAction")
public class MicroTransAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroTransAction.class);
    private IIAMClient iamClient;

    @Autowired
    public void setIAMClient(IIAMClient iamClient) {
        this.iamClient = iamClient;
    }

    @Override
    @ActionMock
    @Debug
    public Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        ServiceResult serviceResult = new ServiceResult(false);
        if (reqMap == null) {
            LOGGER.warn("\u6267\u884cMicroTrans\u5904\u7406\u5165\u53c2\u4e3a\u7a7a");
            return serviceResult;
        }
        long t1 = System.currentTimeMillis();
        TransDataManger transDataManger = new TransDataManger(actionParam.getMicroTrans(), reqMap, context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
        try {
            JSONObject result = this.iamClient.getUserInfoByToken(transDataManger.getToken(), false);
            if (result != null) {
                transDataManger.setLoginUserName(result.getString("name"));
                transDataManger.setUserId(result.getString("email"));
            }
            serviceResult.setData(transEngine.runEngine(transDataManger));
            LogUtils.buildAgileLog("executeMictransAction", LogUtils.SUCCESS, "actionId:" + actionParam.getActionId(), "", "");
        }
        catch (Exception e) {
            serviceResult.setSuccess(false);
            context.setExecuteStatus(false);
            LogUtils.buildAgileLog("executeMictransAction", "P.EE.500.0016", "actionId:" + actionParam.getActionId(), "MICTRANS\u6267\u884c\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a\u3010" + e.getMessage() + "\u3011", "\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        LOGGER.info(String.format("micTrans\uff1a%s\uff0c\u6267\u884c\u8017\u65f6:%s ms", actionParam.getActionId(), System.currentTimeMillis() - t1));
        serviceResult.setSuccess(true);
        context.setExecuteStatus(true);
        return serviceResult.getData();
    }
}

