package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: Athena内部调用
 * @author: zhangww
 * @time: 2020/7/29 20:09
 */
@Service("AthenaAction")
public class AthenaAction extends ActionBase {

    private static final Logger LOGGER = LoggerFactory.getLogger(AthenaAction.class);

    private static final String DIGI_MIDDLEWARE_AUTH_USER = "digi-middleware-auth-user";
    private static final String RESPONSE_STATUS = "status";
    private static final int RESPONSE_CODE_SUCCESS = 200;


    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject metaObj = actionParam.getMetaObj();
        String url = metaObj.getString(MetaDataConstant.ACTION_URL);
        String method = metaObj.getString(MetaDataConstant.ACTION_METHOD);
        String module = metaObj.getString(MetaDataConstant.ACTION_MODULE);
        try {
            Map<String, String> header = new HashMap<>();
            header.put(DIGI_MIDDLEWARE_AUTH_USER, context.getToken());
            header.put("token", context.getToken());
            header.put(CommonConstant.HTTP_HEADER_CONTENT_TYPE_KEY, CommonConstant.HTTP_HEADER_CONTENT_TYPE_VULE);
            header.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, context.getRouterKey());
            if (context.getLocale() != null) {
                header.put(MetaDataConstant.ACTION_LOCALE, context.getLocale());
            }
            reqMap.put("tenantId", context.getTenantId());

            String domainUrl = ModuleProperty.MODULE_DOMAIN_MAP.containsKey(module) ? ModuleProperty.MODULE_DOMAIN_MAP.get(module) : ModuleProperty.ATHENA_DOMAIN_URL;
            String actionUrl = domainUrl + url;

            String httpContent = HttpClientUtils.doRequest(method, actionUrl, header, reqMap);
            LOGGER.info("执行引擎调用ATHENA执行{}:{}返回的结果为：{}", url, reqMap, httpContent);

            if (StringUtils.isBlank(httpContent)) {
                context.setExecuteStatus(false);
                return null;
            }
            JSONObject respObj = JSON.parseObject(httpContent);
            if (null == respObj || RESPONSE_CODE_SUCCESS != respObj.getIntValue(RESPONSE_STATUS)) {
                context.setExecuteStatus(false);
                return null;
            }
            context.setExecuteStatus(true);
            return JSONObject.parseObject(ServiceResponseUtils.getDwServiceResponse(httpContent));
        } catch (Exception e) {
            LOGGER.error("执行引擎触发ATHENA[{}]异常:{}", url, e);
            context.setExecuteStatus(false);
            throw e;
        }
    }
}
