package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/9/12
 */
@Service("InputAction")
public class InputAction extends ActionBase {
    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        Map<String, String> filterMap = analyseFilterParam(context);

        filterMap.forEach((k, v) -> {
            reqMap.put(k, v);
        });
        return reqMap;
    }


    /**
     * 解析语义生成的filter参数
     *
     * @param context
     * @return
     */
    private Map<String, String> analyseFilterParam(ExecuteContext context) {
        JSONObject dynamicSchema = context.getInputParam().getDataDescription().getDynamicSchema();
        JSONObject ds = JSONObject.parseObject(JSONObject.toJSONString(dynamicSchema));
        JSONObject jsonObject = ds.getJSONObject("filter");
        Map<String, String> filterMap = new HashMap<>();
        if (MapUtils.isEmpty(jsonObject)) {
            return filterMap;
        }
        JSONArray children = jsonObject.getJSONArray("children");
        if (CollectionUtils.isEmpty(children)) {
            return filterMap;
        }

        children.forEach(item -> {
            JSONObject child = (JSONObject) item;
            JSONObject left = child.getJSONObject("left");
            JSONArray right = child.getJSONArray("right");
            String key = left.getString("content");
            String value = right.getJSONObject(0).getJSONObject("dataObject").getString("content");
            if (!filterMap.containsKey(key)) {
                filterMap.put(key, value);
            } else {
                String v = filterMap.get(key);
                filterMap.put(key, v + "#" + value);
            }
        });
        return filterMap;
    }

}
