package com.digiwin.athena.executionengine.component.param;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.enumtype.ParamTypeEnum;
import com.digiwin.athena.executionengine.util.ClassUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.Logger;

import java.util.Optional;

/**
 * @description:
 * @author: renwm
 * @date: 2020/6/15 18:21
 */
public class ParamFactory {

    private static final Logger LOGGER = LoggerFactory.getLogger(ParamFactory.class);

    public static ParamBase createParam(JSONObject paramObj) {

        try {

            String type = paramObj.getString(MetaDataConstant.ACTIONS_PARAMS_TYPE);
            ParamTypeEnum typeEnum = ParamTypeEnum.getEnumByType(type);
            ParamBase paramInstance = ClassUtils.getParamInstance(typeEnum.getClassName());
            Optional.ofNullable(paramInstance)
                    .ifPresent(instance -> instance.initInstance(paramObj));
            return paramInstance;
        } catch (Exception e) {
            LOGGER.error("{}创建ParamBase实例对象异常:{}", paramObj, e);
        }
        return null;
    }
}
