package com.digiwin.athena.executionengine.core.holder;

import com.digiwin.athena.executionengine.util.JsonResolverUtils;
import com.jayway.jsonpath.ReadContext;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: 参数映射向下构建取数据处理器
 * @author: ZhangJun
 * @create: 2021/6/7
 */
public class ReadContextHolder {
    private Map<String, ReadContext> readContextMap = new HashMap<>();

    /**
     * 基于ReadContext和jsonpath获取数据
     *
     * @param key
     * @param data
     * @param jsonPath
     * @return
     */
    public Object getData(String key, Object data, String jsonPath) {
        ReadContext readContext = readContextMap.get(key);
        if (readContext == null) {
            readContext = JsonResolverUtils.getReadContext(data, jsonPath);
            readContextMap.put(key, readContext);
        }
        return JsonResolverUtils.getJsonPathVal(readContext, jsonPath);
    }

    public void removeReadContext(String key) {
        readContextMap.remove(key);
    }
}
