package com.digiwin.athena.executionengine.core.property;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * RabbitMQ的相关配置定义处
 *
 * @author zhangzhi@digiwin.com
 * @date 2021/6/30
 */
@Component("engineRabbitProperty")
public class RabbitProperty {
    @Value("${spring.rabbitmq.host}")
    private String host;

    @Value("${spring.rabbitmq.port}")
    private int port;

    @Value("${spring.rabbitmq.username}")
    private String username;

    @Value("${spring.rabbitmq.password}")
    private String password;

    @Value("${spring.rabbitmq.virtual-host}")
    private String virtualHost;

    @Value("${spring.rabbitmq.listener.simple.concurrency:1}")
    private int simpleConcurrency;

    @Value("${spring.rabbitmq.listener.simple.max-concurrency:5}")
    private int simpleMaxConcurrency;

    @Value("${spring.rabbitmq.listener.simple.prefetch:5}")
    private int simplePrefetch;

    @Value("${spring.rabbitmq.listener.simple.retry.initial-interval:1000}")
    private int simpleInitialInterval;

    @Value("${spring.rabbitmq.listener.simple.retry.max-interval:10000}")
    private int simpleMaxInterval;

    @Value("${spring.rabbitmq.listener.simple.retry.multiplier:2}")
    private int simpleMultiplier;

    public String getHost() {
        return host;
    }

    public int getPort() {
        return port;
    }

    public String getUsername() {
        return username;
    }

    public String getPassword() {
        return password;
    }

    public String getVirtualHost() {
        return virtualHost;
    }

    public int getSimpleConcurrency() {
        return simpleConcurrency;
    }

    public int getSimpleMaxConcurrency() {
        return simpleMaxConcurrency;
    }

    public int getSimplePrefetch() {
        return simplePrefetch;
    }

    public int getSimpleInitialInterval() {
        return simpleInitialInterval;
    }

    public int getSimpleMaxInterval() {
        return simpleMaxInterval;
    }

    public int getSimpleMultiplier() {
        return simpleMultiplier;
    }
}
